% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLSPs.R
\name{makeAspect}
\alias{makeAspect}
\title{makeAspect}
\usage{
makeAspect(
  dtm,
  cellSize = 1,
  flatThreshold = 1,
  mode = "aspect",
  writeRaster = FALSE,
  outName,
  device = "cpu"
)
}
\arguments{
\item{dtm}{Input SpatRaster object representing bare earth surface elevations.}

\item{cellSize}{Resolution of raster grid. Default is 1 m.}

\item{flatThreshold}{Maximum slope to be re-coded to flat and assigned an aspect value of -1.
Default is 1-degree.}

\item{mode}{"aspect", "northness", "eastness", "trasp", or "sei". Default is "aspect".}

\item{writeRaster}{TRUE or FALSE. Save output to disk. Default is TRUE.}

\item{outName}{Name of output raster with full file path and extension.}

\item{device}{"cpu" or "cuda". Use "cuda" for GPU computation. Without using the GPU,
implementation will not be significantly faster than using non-tensor-based computation.
Defaults is "cpu".}
}
\description{
Calculate aspect or slope orientation  or a related metric from a digital terrain model (DTM) using torch
}
\details{
Calculate topographic aspect or slope orientation or a related metric using torch
in degree units. Processing on the GPU can be much faster than using base R and non-tensor-based calculations.
"aspect" = topographic aspect in degree units where flat slopes are coded to -1; "northness" = cosine of aspect
in radians; "eastness" = sine of aspect in radians; "trasp" = topographic radiation aspect index; "sei" = site exposure
index.
}
\examples{
\dontrun{
pth <- "OUTPUT PATH"
dtm <- rast(paste0(pth, "dtm.tif"))
aspR <- makeAspect(dtm, cellSize=1,
flatThreshold=1,
mode= "aspect",
writeRaster=TRUE,
outName=paste0(pth, "asp.tif"),
device="cuda")
}
}
