% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewBatch.R
\name{viewBatch}
\alias{viewBatch}
\title{viewBatch}
\usage{
viewBatch(dataLoader, nCols = 3, r = 1, g = 2, b = 3, cNames, cColors)
}
\arguments{
\item{dataLoader}{Instantiated instance of a DataLoader created using torch::dataloader().}

\item{nCols}{Number of columns in the image grid. Default is 3.}

\item{r}{Index of channel to assign to red channel. Default is 1 or first channel.
For gray scale or single-band images, assign the same index to all three bands.}

\item{g}{Index of channel to assign to green channel. Default is 2 or the second channel.
For gray scale or single-band images, assign the same index to all three bands.}

\item{b}{Index of channel to assign to blue channel. Default is 3 or the third channel.
For gray scale or single-band images, assign the same index to all three bands.}

\item{cNames}{Vector of class names. Must be the same length as number of classes.}

\item{cColors}{Vector of color values to use to display the masks. Colors are applied based on the
order of class indices. Length of vector must be the same as the number of classes.}
}
\value{
Image grids of example chips and masks loaded from a mini-batch produced by the DataLoader.
}
\description{
Generate image grid of mini-batch of image chips and associated masks created by a DataLoader.
}
\details{
The goal of this function is to provide a visual check of a mini-batch of image chips and associated masks
generated from a DataLoader.
}
\examples{
\dontrun{
viewBatch(dataLoader=trainDL,
          nCols = 5,
          r = 1,
          g = 2,
          b = 3,
          cNames=c("Background", "Mine"),
          cColors=c("gray", "darksalmon"))
}
}
