% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{barPlots}
\alias{barPlots}
\title{Bar plots}
\usage{
barPlots(data, belongmatrix, ncol = 3, what = "mean")
}
\arguments{
\item{data}{A dataframe with numeric columns}

\item{belongmatrix}{A membership matrix}

\item{ncol}{An integer indicating the number of columns for the bar plot}

\item{what}{Can be "mean" (default) or "median"}
}
\value{
a barplot created with ggplot2
}
\description{
Return bar plots to compare groups
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
barPlots(dataset, result$Belongings)
}
