% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metro_area.R
\name{read_metro_area}
\alias{read_metro_area}
\title{Download shape files of official metropolitan areas in Brazil as an sf object.}
\usage{
read_metro_area(year, tp = "simplified")
}
\arguments{
\item{year}{A year number in YYYY format}

\item{tp}{Whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Default)}
}
\description{
The function returns the shapes of municipalities grouped by their respective metro areas.
Metropolitan areas are created by each state in Brazil. The data set includes the municipalities that belong to
all metropolitan areas in the country according to state legislation in each year. Orignal data were generated
by Institute of Geography. Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674).
}
\examples{
\donttest{

library(geobr)

# Read all official metropolitan areas for a given year
  m <- read_metro_area(2005)

  m <- read_metro_area(2018)
}



}
