##
## Simulando do Modelo Linear Generalizado
##
## Exemplo 1: Modelo Binomial (Bernoulli)
##            com ligao "logit"
## valores da covarivel:
x <- c(23, 28, 25, 27, 32, 45, 51)
n <- length(x)
## Definindo o valor do parmetro $\beta$
beta <- .03

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta)/(1+ exp(x*beta))
mu
## Simulando dados
y <- rbinom(n, size=1, prob=mu)
y

## Exemplo 2: Modelo Poisson
##            com ligao "log"
##            (usando a mesma covarivel)
beta <- 0.05

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta)
mu

## Simulando dados
y <- rpois(n, lam=mu)
y

## Exemplo 3: Modelo Poisson com efeito aleatrio
##            com ligao "log"
beta <- 0.05
x * beta

## simulando o efeito aleatrio
u <- rnorm(n, sd=1)
u
## termo $X\beta + U$
x * beta + u

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta + u)

## Simulando dados com efeito aleatrio
set.seed(123)
y <- rpois(n, lam=mu)
y

## Mesma simulao sem o efeito aleatrio
set.seed(123)
y <- rpois(n, lam=exp(x*beta))
y

## Exemplo 4: Simulando do modelo Poisson
##            com efeito espacial
##            com funo de ligao "log"

## definindo as coordenadas dos pontos
cp <- expand.grid(1:10, 1:10)
cp
plot(cp, asp=1)

## simulando valores nestes pontos
require(geoR)
s <- grf(grid=cp, cov.pars=c(2, 3))$data

## calculando a mdia
mu <- exp(s)

## simulando da Poisson
y <- rpois(100, lam=mu)
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], y, cex=2)

## visualizando S e Y
par(mfrow=c(1,2), mar=c(3,3,0.5,0.5), mgp=c(2,1,0))
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], round(s, dig=2), cex=1.5)
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], y, cex=1.5)

