% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{bf2optim}
\alias{bf2optim}
\title{Empirical Bayes estimator}
\usage{
bf2optim(bfspobj, estimate, useCV = TRUE, control = list())
}
\arguments{
\item{bfspobj}{Output from the function \code{\link{bf1skel}} which
contains the Bayes factors and importance sampling weights.}

\item{estimate}{A named list with the components "linkp", "phi",
"omg", "kappa". Each component must be numeric with length 1, 2,
or 3 with elements in increasing order but for the binomial family
linkp is also allowed to be the character "logit" and "probit". If
its length is 1, then the corresponding parameter is considered to
be fixed at that value. If 2, then the two numbers denote the
lower and upper bounds for the optimisation of that parameter
(infinities are allowed). If 3, these correspond to lower bound,
starting value, upper bound for the estimation of that parameter.}

\item{useCV}{Whether to use control variates for finer
corrections.}

\item{control}{A list of control parameters for the optimisation.
See \code{\link[stats]{optim}}.}
}
\value{
The output from the function \code{\link[stats]{optim}}.
}
\description{
Estimation by empirical Bayes.
}
\details{
This function is a wrap around \code{\link{bf2new}} using the
"L-BFGS-B" method of the function \code{\link[stats]{optim}} to
estimate the parameters.
}

