% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/deg2rect.R
\name{deg2rect}
\alias{d2dr}
\alias{d2mr}
\alias{d2r}
\alias{d2sr}
\alias{deg2rect}
\title{Given position return rectangle code.}
\usage{
d2r(lat, lon = NULL)

d2sr(lat, lon = NULL)

d2mr(lat, lon = NULL, dlat = 5, dlon = 10)

d2dr(lat, lon = NULL, dlat = 1, dlon = 2, startLat = 50)
}
\arguments{
\item{lat,lon}{Position(s) as decimal degrees latitude and longitude.  If
\code{lat} is \code{list} its components \code{lat$lat} and \code{lat$lon}
are used for \code{lat} and \code{lon}.}

\item{dlat,dlon}{Rectangle height and width in degrees and minutes latitude
and longitude for \code{d2dr} and \code{d2mr} respectively.}

\item{startLat}{Starting latitude used in coding the rectangles.}
}
\value{
Vector of rectangle codes in the chosen coding system.
}
\description{
Functions that convert positions in decimal degrees latitude and longitude
to rectangle codes for statistical rectangles, their subrectangles or
rectangle codes in systems of various resolutions as described below and
relating to (see \code{\link{rect2deg}}).
}
\details{
\itemize{

\item \code{r2d} with a resolution of 30 min latitue and 1 deg longitude
(the Icelandic numbering system, 'tilkynningaskyldureitir').

\item \code{sr2d} with a resolution of 15 min latitude by 30 min longitude
in the Icelandic numbering system for statistical rectangles which starts
counting at 60 deg N latitude, with sub-rectangles of 30 min lat by 1 deg
lon coded 1, 2, 3 and 4 for the NW, NA, SW and SA quadrants respectively

}

A small number (1e-06) is added to latitude and subtracted from longitude to
ensure rectangle membership of positions on border are \dQuote{logical} on
the nw-hempisphere.
}
\note{
These functions could be made hemisphere-aware, and no attention has
been given to making the functions work in the southern hemisphere, possibly
with the option of specifying starting latitudes.
}
\examples{
## tally positions in rectangles in object \\code{\\link{island}} giving
## Iceland's coastline

data(island)
rects <- d2r(island)
table(rects)
}
\author{
HB (\code{d2r, d2sr}, STJ (\code{d2mr, d2dr}).
}
\seealso{
\code{\link{rect2deg}}
}
\keyword{arith}
\keyword{manip}

