% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll_zero_finder.R
\name{ll_zero_finder2}
\alias{ll_zero_finder2}
\title{Zero finding function}
\usage{
ll_zero_finder2(af, ii = 6, lower = 0, upper = 1, qdelta = 27)
}
\arguments{
\item{af}{The function for which to find the zero(s)}

\item{ii}{Number of iterations. The more iterations, the more accuracy. It is recommended that ii be at least 4.}

\item{lower}{Lower limit of region in which to find the zero}

\item{upper}{Upper limit of region in which to find the zero}

\item{qdelta}{Factor for finding intervals over which the function is close to zero}
}
\value{
Points over the given interval at which the given function is approximately equal to zero
}
\description{
Finds the zeros of a function af. Alternative to uniroot, designed specifically to work with the genpwr package.
Finds multiple zeros if a function has more than one in the given range.
}
\examples{
ll_zero_finder2(function(x) (x-0.5)^2 - 0.1)
ll_zero_finder2(function(x) 8*x^3 - 11.2*x^2 + 4.56*x - 0.476)

}
