% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_power_functions_in_progress.R
\name{power.calc.linear}
\alias{power.calc.linear}
\title{Function to Calculate Power for Linear Models}
\usage{
power.calc.linear(
  N = NULL,
  MAF = NULL,
  ES = NULL,
  R2 = NULL,
  sd_y = NULL,
  Alpha = 0.05,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{N}{Vector of the desired sample size(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{ES}{Vector of effect sizes (difference in means) to detect. Either ES or R2 must be specified.}

\item{R2}{Vector of R-squared values to detect. Either ES or R2 must be specified.}

\item{sd_y}{Standard deviation of the outcome in the population (ignoring genotype). Either sd_y_x or sd_y must be specified.}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive1', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the power to detect an difference in means/effect size/regression coefficient, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
pw <- power.calc.linear(N=1000,
    MAF=0.1, ES=3,sd_y = 1,Alpha=0.05,
    True.Model='All', Test.Model='All')

}
