% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_plink.R
\name{write_plink}
\alias{write_plink}
\title{Write genotype and sample data into a plink BED/BIM/FAM file set.}
\usage{
write_plink(file, X, bim = NULL, fam = NULL, pheno = NULL,
  verbose = TRUE)
}
\arguments{
\item{file}{Output file path, without extensions (each of .bed, .bim, .fam extensions will be added automatically as needed).}

\item{X}{The \eqn{m \times n}{m-by-n} genotype matrix.}

\item{bim}{The tibble or data.frame containing locus information.
It must contain \eqn{m} rows and these columns: chr, id, posg, pos, ref, alt.
If NULL (default), it will be quietly auto-generated.}

\item{fam}{The tibble or data.frame containing individual information.
It must contain \eqn{n} rows and these columns: fam, id, pat, mat, sex, pheno.
If NULL (default), it will be quietly auto-generated.}

\item{pheno}{The phenotype to write into the FAM file assuming \code{fam=NULL}.
This must be a length-\eqn{n} vector.
This will be ignored (with a warning) if \code{fam} is provided.}

\item{verbose}{If TRUE (default) function reports the paths of the files being written (after autocompleting the extensions).}
}
\description{
This function writes a genotype matrix (X) and its associated locus (bim) and individual (fam) data tables into three plink files in BED, BIM, and FAM formats, respectively.
This function is a wrapper around the more basic functions
\code{\link{write_bed}},
\code{\link{write_bim}},
\code{\link{write_fam}},
but additionally tests that the data dimensions agree (or stops with an error).
Also checks that the genotype row and column names agree with the bim and fam tables if they are all present.
In addition, if \code{bim = NULL} or \code{fam = NULL}, these are auto-generated using
\code{\link{make_bim}} and
\code{\link{make_fam}},
which is useful behavior for simulated data.
Lastly, the phenotype can be provided as a separate argument and incorporated automatically if \code{fam=NULL} (a common scenario for simulated genotypes and traits).
Below suppose there are \eqn{m} loci and \eqn{n} individuals.
}
\examples{
# here is an example for a simulation

# create 10 random genotypes
X <- rbinom(10, 2, 0.5)
# replace 3 random genotypes with missing values
X[sample(10, 3)] <- NA
# turn into 5x2 matrix
X <- matrix(X, nrow = 5, ncol = 2)

# simulate a trait for two individuals
pheno <- rnorm(2)

# write this data to BED/BIM/FAM files
# output path without extension
file_out <- tempfile('delete-me-example')
# here all of the BIM and FAM columns except `pheno` are autogenerated
write_plink(file_out, X, pheno = pheno)

# delete all three outputs when done
delete_files_plink( file_out )

}
\seealso{
\code{\link{write_bed}},
\code{\link{write_bim}},
\code{\link{write_fam}},
\code{\link{make_bim}},
\code{\link{make_fam}}.

Plink BED/BIM/FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats}
}
