% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer-shiny.R
\name{geneviewer-shiny}
\alias{geneviewer-shiny}
\alias{GC_chartOutput}
\alias{renderGC_chart}
\title{Shiny bindings for geneviewer}
\usage{
GC_chartOutput(outputId, width = "100\%", height = "400px")

renderGC_chart(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, }{height Must be a valid CSS unit (like '100%', '400px', 'auto')
or a number, which will be coerced to a string and have 'px' appended.}

\item{height}{Height of the output widget, must be a valid CSS unit (like
'100%', '400px', 'auto') or a number, which will be coerced to a string and
have 'px' appended.}

\item{expr}{An expression that generates a GC chart.}

\item{env}{The environment in which to evaluate expr.}

\item{quoted}{Is expr a quoted expression (with quote())? This is useful if
you want to save an expression in a variable.}
}
\value{
GC_chart widget that can be placed in the UI.
}
\description{
Output and render functions for using geneviewer within Shiny applications and
interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(shiny)
  library(geneviewer)

  ui <- fluidPage(
    titlePanel("Omphalotin Gene Cluster Visualization"),
    mainPanel(
      GC_chartOutput("gcChart", width = "100\%", height = "500px")
    )
  )

  server <- function(input, output) {
    output$gcChart <- renderGC_chart({
      GC_chart(
        ophA_clusters, # Ensure 'ophA_clusters' data is defined or available
        cluster = "cluster",
        group = "class"
      ) \%>\%
      GC_title(title = c("<i>O. olearius</i>", "<i>D. bispora</i>")) \%>\%
      GC_labels("name") \%>\%
      GC_legend(position = "bottom") \%>\%
      GC_scaleBar() \%>\%
      GC_clusterLabel(title = "ophA")
    })
  }

  shinyApp(ui = ui, server = server)
}
}
\seealso{
[GC_chart()]
}
