% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_network.R
\name{plotHapNet}
\alias{plotHapNet}
\title{plotHapNet}
\usage{
plotHapNet(hapNet,
           size = "freq",
           scale = 1,
           cex = 0.8,
           cex.legend = 0.6,
           col.link = 1,
           link.width = 1,
           show.mutation = 1,
           backGround = backGround,
           hapGroup = hapGroup,
           legend = FALSE,
           show_size_legend = TRUE,
           show_color_legend = TRUE,
           main = main,
           labels = TRUE,
           ...)
}
\arguments{
\item{hapNet}{an object of class "haploNet"}

\item{size}{a numeric vector giving the diameter of the circles
representing the haplotypes: this is in the same unit than the
links and eventually recycled.}

\item{scale}{a numeric indicate the ratio of the scale of the links
representing the number of steps on the scale of the circles
representing the haplotypes or a character one of \code{c('log10', 'log2')}
indicate the scale method by \code{log10(size)} or \code{log2(size)}, respectively.
Default as 1}

\item{cex}{character expansion factor relative to current par("cex")}

\item{cex.legend}{same as \code{cex}, but for text in legend}

\item{col.link}{a character vector specifying the colours of the links;
eventually recycled.}

\item{link.width}{a numeric vector giving the width of the links;
eventually recycled.}

\item{show.mutation}{an integer value:

if 0, nothing is drawn on the links;

if 1, the mutations are shown with small segments on the links;

if 2, they are shown with small dots;

if 3, the number of mutations are printed on the links.}

\item{backGround}{a color vector with length equal to number of
Accession types}

\item{hapGroup}{a matrix used to draw pie charts for each haplotype;
its number of rows must be equal to the number of haplotypes}

\item{legend}{a logical specifying whether to draw the legend,
or a vector of length two giving the coordinates where to draw the legend;
\code{FALSE} by default.
If \code{TRUE}, the user is asked to click where to draw the legend.}

\item{show_size_legend, show_color_legend}{wether show size or color legend}

\item{main}{The main title (on top) using font, size (character
    expansion) and color \code{par(c("font.main", "cex.main", "col.main"))}.}

\item{labels}{a logical specifying whether to identify the haplotypes
with their labels (default as TRUE)}

\item{...}{other parameters will pass to \code{plot} function}
}
\value{
No return value
}
\description{
plotHapNet
}
\examples{

\donttest{
data("geneHapR_test")
hapSummary <- hap_summary(hapResult)

# calculate haploNet
hapNet <- get_hapNet(hapSummary,
                     AccINFO = AccINFO, # accession types
                     groupName = colnames(AccINFO)[2])

# plot haploNet
plot(hapNet)

# plot haploNet
plotHapNet(hapNet,
           size = "freq",   # circle size
           scale = "log10", # scale circle with 'log10(size + 1)'
           cex = 1, # size of hap symbol
           col.link = 2, # link colors
           link.width = 2, # link widths
           show.mutation = 2, # mutation types one of c(0,1,2,3)
           legend = FALSE) # legend position
}
}
\seealso{
\code{\link[geneHapR:hap_summary]{hap_summary()}} and
\code{\link[geneHapR:get_hapNet]{get_hapNet()}}.
}
