/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.NonSuspendable;
import org.drugis.common.threading.Suspendable;

public class SuspendableThreadWrapper {
    private Thread d_thread;
    private final Suspendable d_runnable;

    public SuspendableThreadWrapper(Suspendable runnable) {
        this.d_runnable = runnable;
    }

    public SuspendableThreadWrapper(Runnable runnable) {
        this(SuspendableThreadWrapper.wrap(runnable));
    }

    private static Suspendable wrap(Runnable runnable) {
        if (runnable instanceof Suspendable) {
            return (Suspendable)runnable;
        }
        return new NonSuspendable(runnable);
    }

    public synchronized void start() {
        if (this.d_thread == null) {
            this.startAsNewThread();
        } else {
            this.resumeThread();
        }
    }

    public synchronized boolean suspend() {
        if (this.d_thread == null) {
            throw new IllegalStateException("Thread not started yet");
        }
        return this.d_runnable.suspend();
    }

    public boolean isTerminated() {
        if (this.d_thread == null) {
            return false;
        }
        return this.d_thread.getState() == Thread.State.TERMINATED;
    }

    public boolean terminate() {
        if (this.d_thread == null) {
            return true;
        }
        return this.d_runnable.abort();
    }

    private void startAsNewThread() {
        this.d_thread = new Thread(this.d_runnable);
        this.d_thread.start();
    }

    private void resumeThread() {
        if (this.d_runnable.isSuspended()) {
            this.d_runnable.wakeUp();
        }
    }

    public Runnable getRunnable() {
        return this.d_runnable;
    }

    public String toString() {
        return this.d_runnable.toString();
    }

    public boolean isAborted() {
        return this.d_runnable.isAborted();
    }
}

