% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_image.R
\name{gen_image}
\alias{gen_image}
\title{Generate and save image using Gemini}
\usage{
gen_image(
  prompt,
  filename = "gemini_image.png",
  overwrite = TRUE,
  model = "2.0-flash-exp-image-generation",
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{prompt}{The prompt to generate an image from}

\item{filename}{The filename to save the image to. Default is "gemini_image.png"}

\item{overwrite}{Logical, whether to overwrite existing file. Default is TRUE}

\item{model}{The model to use. Default is "2.0-flash-exp-image-generation"}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}
}
\value{
The path to the saved file or NULL if an error occurred
}
\description{
Generate an image using Gemini's image generation capabilities and save it to a file
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gen_image("Create an image of a cat wearing sunglasses")
}
}
