% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_funs.R
\docType{methods}
\name{create_psiFUN_list}
\alias{create_psiFUN_list}
\alias{create_psiFUN_list,m_estimation_basis-method}
\alias{create_psiFUN_list,m_estimation_basis,m_estimation_basis-method}
\title{Creates list of psi functions}
\usage{
create_psiFUN_list(object, ...)

\S4method{create_psiFUN_list}{m_estimation_basis}(object)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{m_estimation_basis}}}

\item{...}{additional arguments passed to other methods}
}
\value{
the \code{object} with the \code{.psiFUN_list} slot populated.
}
\description{
Creates the estimating function (\eqn{\psi(O_i, \theta)}{\psi(O_i, \theta)})
for each unit. That is, this function evaluates the outer function in
\code{estFUN} for each independent unit and a returns the inner function in
\code{estFUN}.
}
\examples{
myee <- function(data){
   function(theta){
    c(data$Y1 - theta[1],
     (data$Y1 - theta[1])^2 - theta[2])
   }
 }
mybasis <- create_basis(
   estFUN = myee,
   data   = geexex)
psi_list <- grab_psiFUN_list(create_psiFUN_list(mybasis))

# A list of functions
head(psi_list)
}
