% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_get_request.R
\name{build_get_request}
\alias{build_get_request}
\title{Build URLs for \code{GET} requests}
\usage{
build_get_request(
  base_url = "https://api.coingecko.com",
  path,
  query_parameters
)
}
\arguments{
\item{base_url}{(character): API's base URL (host). Defaults to
\code{"https://api.coingecko.com"}.}

\item{path}{(character or \code{NULL}): vector, whose elements form the path of the
respective API endpoint. The order of these elements is important. For
example, if the path is \code{api/v3/ping}, then this vector must be
\code{path = c("api", "v3", "ping")}.}

\item{query_parameters}{(named list or \code{NULL}): contains parameters of the
request.}
}
\value{
A URL that is ready to be used in a \code{GET} request.
}
\description{
Returns URLs properly formatted for \code{GET} requests
}
\details{
No validation of the base URL is performed by this function,
so users are advised to ensure that the base URL is correctly
formatted and encoded.
}
\keyword{internal}
