% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ganiso_d.R
\name{ganiso_d}
\alias{ganiso_d}
\title{Anisotropic distance-related characteristics}
\usage{
ganiso_d(coords1, coords2, radians = TRUE, invert = TRUE)
}
\arguments{
\item{coords1}{An \eqn{N \times 2} matrix of spatial coordinates.}

\item{coords2}{An \eqn{M \times 2} matrix of spatial
coordinates. Is missing, then \code{coords2 = coords1}.}

\item{radians}{A logical value indicating whether degrees or radians should be returned.  Default is FALSE, meaning return angle in degrees.}

\item{invert}{A logical value indicating whether the axes
of the coordinates should be inverted (i.e., the x- and y-axis are
switched). The default is
\code{TRUE} to mimic results from
other geostatistical R packages like \code{gstat},
\code{geoR} or other software like \code{GSLIB} and
\code{GeoEAS}. Set to \code{FALSE} to use the typical
x- and y-axis.}
}
\value{
A \code{ganisoD} object with components \code{d}
  and \code{angles}, which is the distance matrix between
  the coordinates and the angles between the coordinates.
  The angles are returned in radians.
}
\description{
Computes necessary distance-related characteristics when
there is geometric anisotropy. This is essentially an
internal function to \code{\link{evaluate}} a
\code{cmodStd} object produced by \code{\link{cmod_std}}
when the \code{ganiso} argument is not \code{NULL}.
}
\examples{
ganiso_d(cbind(0, 0), cbind(1, 1))
}
