\name{rgbvolmap}
\alias{rgbvolmap}
\concept{RGB maps}

\title{Generalized Fractional Anisotropy (GFA) Maps (RGB Maps) }

\description{
Using GFA data and the main direction of ODF profiles produced by \code{gqi.odfpeaks} or \code{gqi.odfvmf}, \code{rgbvolmap} displays RGB maps.
}

\usage{
rgbvolmap(fbase=NULL, rg=c(1,1),  bview="coronal",
 texture=NULL, bg="black")
}

\arguments{
\item{fbase}{ Directory where the required input data files are located. } 
\item{rg}{ range of slices to process (default option \code{rg=c(1,1)}); \code{rg=NULL} processes all slices. }
\item{bview}{ MRI slice view selection in \{\code{axial, coronal, sagittal}\} (default: \code{"coronal"}). }
\item{texture}{ PNG file name and location to store image, to be used as texture in overlay maps (default\code{NULL}). }
\item{bg}{ background colour (default \code{"black"}). }
}

\details{
The standard convention for colour assignment when combining GFA values with directional information is adopted (see Pajevic, et.al.; Jellison et.al.).
Colour hue indicates direction as follows: red, left-right; green, antero-posterior; blue, superior-inferior.
Brightness is proportional to GFA.
The output files \file{data_V1.nii.gz} and \file{data_gfa.nii.gz} are compatible with the "FSL/fslview" tool for RGB map and line map visualization.
}

\note{
Commonly used acronyms:\cr
GFA - Generalized Fractional Anisotropy\cr
ODF - Orientation Distribution Function\cr
GQI - Generalized q-Sampling Imaging\cr
dMRI - Diffusion Magnetic Resonance Imaging\cr
RGB maps - Red-Green-Blue colour maps\cr
}

\references{
Ferreira da Silva, A. R. Computational Representation of White Matter Fiber Orientations, \emph{International Journal of Biomedical Imaging}, Vol. 2013, Article ID 232143, Hindawi Publishing Corporation \url{http://dx.doi.org/10.1155/2013/232143}.

Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Auguie, B. \pkg{gridExtra}: functions in Grid graphics, 2012. R package version 0.9.1.

Pajevic, S., and Pierpaoli, C. Color Schemes to Represent the Orien-
tation of Anisotropic Tissues From Diffusion Tensor Data: Application to
White Matter Fiber Tract Mapping in the Human Brain. Magnetic Resonance in Medicine 42 (1999), 526-540.

Jellison, B. J., Field, A. S., Medow, J., Lazar, M., Salamat, M. S.,
and Alexander, A. L. Diffusion tensor imaging of cerebral white matter:
 A pictorial review of physics, fiber tract anatomy, and tumor imaging
patterns. \emph{AJNR Am. J. Neuroradiology} 25 (2004), 356-369.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfpeaklines}},
  \code{\link{gqi.odfvmf}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{gqi.odfvxgrid}},
  \code{\link{plotglyph}},
  \code{\link{s2tessel.zorder}}
}

\examples{
\dontrun{
    ##-------------
    ## Generate ODF volumes (GQI volume processing) for
    ## range of slices using deterministic find peaks algorithm
    gqi.odfpeaks(rg=c(1,1), showglyph=FALSE)
    ## Show RGB maps for range of slices processed by gqi.odfpeaks()
    rgbvolmap(fbase=tempdir(), rg=c(1,1))
    ## Changing background colour
    rgbvolmap(fbase=tempdir(), rg=c(1,1), bg="transparent")
    ##-------------
    ## Process whole volume: generates NIfTI files
    ##   data_gfa_gqi.nii.gz and data_V1_gqi.nii.gz
    gqi.odfpeaks(rg=NULL)
    ## Visualization of RBG maps generated by vMF function "gqi.odfvmf"
    ## (cf. FSL/fslview tool) 
    rgbvolmap(fbase=tempdir(), rg=NULL, bview="coronal")
}
}

\keyword{ dplot }

