% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{getCreationOptions}
\alias{getCreationOptions}
\title{Return the list of creation options of a GDAL driver}
\usage{
getCreationOptions(format, filter = NULL)
}
\arguments{
\item{format}{Raster format short name (e.g., "GTiff").}

\item{filter}{Optional character vector of creation option names. Controls
only the amount of information printed to the console.
By default, information for all creation options is printed. Can be set to
empty string \code{""} to disable printing information to the console.}
}
\value{
Invisibly, an XML string that describes the full list of creation
options or empty string \code{""} (full output of
\code{GDALGetDriverCreationOptionList()} in the GDAL API).
}
\description{
\code{getCreationOptions()} returns the list of creation options supported by a
GDAL format driver as an XML string (invisibly).
Wrapper for \code{GDALGetDriverCreationOptionList()} in the GDAL API.
Information about the available creation options is also printed to the
console by default.
}
\examples{
getCreationOptions("GTiff", filter="COMPRESS")
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}}
}
