% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ms.R
\name{plot_defect}
\alias{plot_defect}
\title{Plots the Kendrick Mass Defect of a peak}
\usage{
plot_defect(ms, compound_mass = 14.01565, title = "Kendrick Mass Defect")
}
\arguments{
\item{ms}{a \emph{data.frame} object. A data frame of the mass values and the
percent intensity values, ideally the output of find_ms().}

\item{compound_mass}{a \emph{float} object. The exact mass, using most common
ions, of the desired atom group to base the Kendrick mass on. Default is
14.01565, which is the mass for CH_2.}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "Kendrick Mass Defect".}
}
\value{
A \emph{ggplot} object. A line plot of the mass spectra data. The
mass values vs the percent intensity values as a percent of the highest
intensity.
}
\description{
\code{plot_defect} Plots Kendrick Mass Defect of a peak.
}
\details{
This function produces a scatter  plot of the Kendrick mass defects
for mass spectrum data. Plotted using \code{\link[ggplot2]{ggplot}} from
ggplot2 package \insertCite{ggplot2}{gcxgclab}.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
mz <- find_ms(frame, t_peak=peaks$'T'[1])
plot_ms(mz)
plot_defect(mz,title="Kendrick Mass Defect, CH_2")

}
\references{
\insertAllCited{}
}
