% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{train_smooth_data}
\alias{train_smooth_data}
\title{Test efficacy of different smoothing parameters}
\usage{
train_smooth_data(
  ...,
  x = NULL,
  y = NULL,
  sm_method,
  preProcess = NULL,
  weights = NULL,
  metric = ifelse(is.factor(y), "Accuracy", "RMSE"),
  maximize = ifelse(metric \%in\% c("RMSE", "logLoss", "MAE", "logLoss"), FALSE, TRUE),
  trControl = caret::trainControl(method = "cv"),
  tuneGrid = NULL,
  tuneLength = ifelse(trControl$method == "none", 1, 3),
  return_trainobject = FALSE
)
}
\arguments{
\item{...}{Arguments passed to \code{smooth_data}. These arguments cannot
overlap with any of those to be tuned.}

\item{x}{A vector of predictor values to smooth along (e.g. time)}

\item{y}{A vector of response values to be smoothed (e.g. density).}

\item{sm_method}{Argument specifying which smoothing method should
be used. Options include "moving-average", "moving-median", 
"loess", "gam", and "smooth.spline".}

\item{preProcess}{A string vector that defines a pre-processing of the
predictor data. The default is no pre-processing.
See \code{caret::train} for more details.}

\item{weights}{A numeric vector of case weights. This argument currently
does not affect any \code{train_smooth_data} models.}

\item{metric}{A string that specifies what summary metric will be
used to select the optimal model. By default, possible
values are "RMSE" and "Rsquared" for regression.
See \code{caret::train} for more details.}

\item{maximize}{A logical: should the metric be maximized or minimized?}

\item{trControl}{A list of values that define how this function acts.
See \code{caret::train} and \code{caret::trainControl}
for more details.}

\item{tuneGrid}{A data frame with possible tuning values, or a named list
containing vectors with possible tuning values. If a data 
frame, the columns should be named the same as the tuning 
parameters. If a list, the elements of the list should be
named the same as the tuning parameters. If a list,
\code{expand.grid} will be used to make all possible
combinations of tuning parameter values.}

\item{tuneLength}{An integer denoting the amount of granularity in
the tuning parameter grid. By default, this argument
is the number of levels for each tuning parameter that
should be generated. If \code{trControl} has the option
\code{search = "random"}, this is the maximum number
of tuning parameter combinations that will be generated
by the random search. (NOTE: If given, this argument
must be named.)}

\item{return_trainobject}{A logical indicating whether the entire result
of \code{caret::train} should be returned, or
only the \code{results} element.}
}
\value{
If \code{return_trainobject = FALSE} (the default), a data frame
        with the values of all tuning parameter combinations and the
        training error rate for each combination (i.e. the \code{results}
        element of the output of \code{caret::train}).
        
        If \code{return_trainobject = TRUE}, the output of \code{caret::train}
}
\description{
This function is based on \code{caret::train}, which runs models
(in our case different smoothing algorithms) on data across different 
parameter values (in our case different smoothness parameters).
}
\details{
See \code{caret::train} for more information.

         The default method is k-fold cross-validation 
         (\code{trControl = caret::trainControl(method = "cv")}). 
         
         For less variable, but more computationally costly, cross-validation,
         users may choose to increase the number of folds. This can be
         done by altering the \code{number} argument in 
         \code{caret::trainControl}, or by setting \code{method = "LOOCV"} 
         for leave one out cross-validation where the number of folds is 
         equal to the number of data points. 
         
         For less variable, but more computationally costly, cross-validation,
         users may alternatively choose \code{method = "repeatedcv"} for 
         repeated k-fold cross-validation.

         For more control, advanced users may wish to call 
         \code{caret::train} directly, using \code{makemethod_train_smooth_data} to 
         specify the \code{method} argument.
}
