% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{write_blocks}
\alias{write_blocks}
\title{Write block designs to csv}
\usage{
write_blocks(
  blocks,
  file,
  output_format = "multiple",
  block_name_location = NULL,
  block_name_header = "block_name",
  paste_sep = "_",
  filename_sep = "_",
  na = "",
  dir = NULL,
  ...
)
}
\arguments{
\item{blocks}{list of block-shaped data to be written to file}

\item{file}{\code{NULL}, a character string naming a file to write to, or a 
            vector of character strings naming files to write to. 

            A file name is required when \code{output_format = "single"}
            
            A file name can be specified when \code{output_format = "pasted"},
            or \code{file} can be set to \code{NULL} as long as 
            \code{block_name_location = "filename"} (where pasted 
            \code{block_name} metadata will be used for the file name)
            
            File names can be specified when \code{output_format = "multiple"},
            or \code{file} can be set to \code{NULL} as long as 
            \code{block_name_location = "filename"} (where the 
            \code{block_name} metadata will be used for the file names)}

\item{output_format}{One of "single", "pasted", "multiple".

                     "single" will write all blocks into a single
                     csv file, with an empty row between successive
                     blocks.
                     
                     "pasted" will paste all blocks together using a
                     \code{paste_sep}, and then write that now-pasted
                     block to a single csv file.
                     
                     "multiple" will write each block to its own csv file.}

\item{block_name_location}{Either \code{NULL}, 'filename' or 'file'.

                          If \code{NULL}, \code{block_name_location} will 
                          be automatically selected based on 
                          \code{output_format}. For 
                          \code{output_format = 'single'} and 
                          \code{output_format = 'pasted'}, 
                          \code{block_name_location} defaults to 'file'.
                          For \code{output_format = 'multiple'}, 
                          \code{block_name_location} defaults to 'filename'

                          If 'filename', the \code{block_name} metadata 
                          will be used as the output file name(s) when
                          no file name(s) are provided, or appended to
                          file name(s) when they have been provided.
                          
                          If 'file', the \code{block_name} metadata will be
                          included as a row in the output file.}

\item{block_name_header}{The name of the field containing the
\code{block_names}}

\item{paste_sep}{When \code{output_format = 'pasted'}, what character
will be used to paste together blocks.}

\item{filename_sep}{What character will be used to paste together 
filenames when block_name_location = 'filename'.}

\item{na}{The string to use for missing values in the data.}

\item{dir}{The directory that file(s) will be written into. When 
\code{dir = NULL}, writes to the current working directory.
(Can only be used when \code{file = NULL})}

\item{...}{Other arguments passed to \code{write.table}}
}
\value{
Nothing, but R objects are written to files
}
\description{
This function writes block-shaped lists (as created by
\code{read_blocks} or \code{make_design}) to csv files, including
both \code{data} and \code{metadata} in a variety of output formats
}
