% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{merge_dfs}
\alias{merge_dfs}
\title{Collapse a list of dataframes, or merge two dataframes together}
\usage{
merge_dfs(
  x,
  y = NULL,
  by = NULL,
  drop = FALSE,
  collapse = FALSE,
  names_to = NA,
  ...
)
}
\arguments{
\item{x}{First data.frame, or list of data frames, to be joined}

\item{y}{Second data.frame, or list of data frames, to be joined}

\item{by}{A character vector of variables to join by, passed directly
to \code{dplyr::full_join}}

\item{drop}{Should only \code{complete_cases} of the resulting
data.frame be returned?}

\item{collapse}{A Boolean indicating whether x or y is a list containing
data frames that should be merged together before
being merged with the other}

\item{names_to}{Column name for where \code{names(x)} or \code{names(y)} 
will be entered in if \code{collapse = TRUE}.

If a value of \code{NA} then \code{names(x)} or 
\code{names(y)} will not be put into a column in the
returned data.frame}

\item{...}{Other arguments to pass to \code{dplyr::full_join}}
}
\value{
Data.frame containing merged output of \code{x} and
        \code{y}
}
\description{
This function is essentially a wrapper for \code{dplyr::full_join}
The most typical use of this function is to merge designs 
with measures data, or to use the collapse functionality of this 
function to merge a list of dataframes into a single dataframe.
Merging is done by column-names that match between \code{x} and \code{y}.
}
