% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm-summary.r
\name{summary.GBMFit}
\alias{summary.GBMFit}
\title{Summary of a GBMFit object}
\usage{
\method{summary}{GBMFit}(
  object,
  cBars = length(object$variables$var_names),
  num_trees = length(trees(object)),
  plot_it = TRUE,
  order_it = TRUE,
  method = relative_influence,
  normalize = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{GBMFit} object created from an initial call
to \code{\link{gbmt}}.}

\item{cBars}{the number of bars to plot. If \code{order_it=TRUE}
then only the \code{cBars} variables with the largest relative
influence will appear in the barplot. If \code{order_it=FALSE} then
the first \code{cBars} variables will appear in the plot. In either
case, the function will return the relative influence of all of the
variables.}

\item{num_trees}{the number of trees used to generate the
plot. Only the first \code{num_trees} trees will be used.}

\item{plot_it}{an indicator as to whether the plot is generated.}

\item{order_it}{an indicator as to whether the plotted and/or
returned relative influences are sorted.}

\item{method}{The function used to compute the relative influence.
\code{\link{relative_influence}} is the default and is the same as
that described in Friedman (2001). The other current (and
experimental) choice is
\code{\link{permutation_relative_influence}}. This method randomly
permutes each predictor variable at a time and computes the
associated reduction in predictive performance. This is similar to
the variable importance measures Breiman uses for random forests,
but \code{gbm} currently computes using the entire training dataset
(not the out-of-bag observations).}

\item{normalize}{if \code{FALSE} then \code{summary.gbm} returns
the unnormalized influence.}

\item{...}{other arguments passed to the plot function.}
}
\value{
Returns a data frame where the first component is the
variable name and the second is the computed relative influence,
normalized to sum to 100.
}
\description{
Computes the relative influence of each variable in the
\code{GBMFit} object.
}
\details{
For \code{GBMGaussianDist} this returns exactly the reduction of
squared error attributable to each variable. For other loss
functions this returns the reduction attributable to each variable
in sum of squared error in predicting the gradient on each
iteration. It describes the relative influence of each variable in
reducing the loss function. See the references below for exact
details on the computation.
}
\references{
J.H. Friedman (2001). "Greedy Function Approximation: A
Gradient Boosting Machine," Annals of Statistics 29(5):1189-1232.

L. Breiman (2001). \href{https://www.stat.berkeley.edu/~breiman/randomforest2001.pdf}{Random Forests}.
}
\seealso{
\code{\link{gbmt}}
}
\author{
James Hickey, Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{hplot}
