% Generated by roxygen2 (4.0.1): do not edit by hand
\name{genAlg}
\alias{genAlg}
\title{Genetic algorithm for variable subset selection}
\usage{
genAlg(y, X, control, evaluator = evaluatorPLS(), seed)
}
\arguments{
\item{y}{The numeric response vector of length n}

\item{X}{A n x p numeric matrix with all p covariates}

\item{control}{Options for controlling the genetic algorithm. See \code{\link{genAlgControl}} for details.}

\item{evaluator}{The evaluator used to evaluate the fitness of a variable subset. See
\code{\link{evaluatorPLS}}, \code{\link{evaluatorLM}} or \code{\link{evaluatorUserFunction}} for details.}

\item{seed}{Integer with the seed for the random number generator or NULL to automatically seed the RNG}
}
\value{
An object of type \code{\link{GenAlg}}
}
\description{
A genetic algorithm to find "good" variable subsets based on internal PLS evaluation or a user specified
evaluation function
}
\details{
The GA generates an initial "population" of \code{populationSize} chromosomes where each initial
chromosome has a random number of randomly selected variables. The fitness of every chromosome is evaluated by
the specified evaluator. The default built-in PLS evaluator (see \code{\link{evaluatorPLS}}) is the preferred
evaluator.
Chromosomes with higher fitness have higher probability of mating with another chromosome. \code{populationSize / 2} couples each create
2 children. The children are created by randomly mixing the parents' variables. These children make up the new generation and are again
selected for mating based on their fitness. A total of \code{numGenerations} generations are built this way.
The algorithm returns the last generation as well as the best \code{elitism} chromosomes from all generations.
}
\examples{
ctrl <- genAlgControl(populationSize = 100, numGenerations = 15, minVariables = 5,
    maxVariables = 12, verbosity = 1)

evaluatorSRCV <- evaluatorPLS(numReplications = 2, innerSegments = 7, testSetSize = 0.4,
    numThreads = 1)

evaluatorRDCV <- evaluatorPLS(numReplications = 2, innerSegments = 5, outerSegments = 3,
    numThreads = 1)

# Generate demo-data
set.seed(12345)
X <- matrix(rnorm(10000, sd = 1:5), ncol = 50, byrow = TRUE)
y <- drop(-1.2 + rowSums(X[, seq(1, 43, length = 8)]) + rnorm(nrow(X), 1.5));

resultSRCV <- genAlg(y, X, control = ctrl, evaluator = evaluatorSRCV, seed = 123)
resultRDCV <- genAlg(y, X, control = ctrl, evaluator = evaluatorRDCV, seed = 123)

subsets(resultSRCV, 1:5)
subsets(resultRDCV, 1:5)
}

