% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gargle-package.R, R/ui.R
\name{gargle_options}
\alias{gargle_options}
\alias{gargle_oauth_email}
\alias{gargle_oob_default}
\alias{gargle_oauth_cache}
\alias{gargle_verbosity}
\alias{local_gargle_verbosity}
\alias{with_gargle_verbosity}
\title{Options consulted by gargle}
\usage{
gargle_oauth_email()

gargle_oob_default()

gargle_oauth_cache()

gargle_verbosity()

local_gargle_verbosity(level, env = parent.frame())

with_gargle_verbosity(level, code)
}
\arguments{
\item{level}{Verbosity level: "debug" > "info" > "silent"}

\item{env}{The environment to use for scoping}

\item{code}{Code to execute with specified verbosity level}
}
\description{
Wrapper functions around options consulted by gargle, which provide:
\itemize{
\item A place to hang documentation.
\item The mechanism for setting a default.
}

If the built-in defaults don't suit you, set one or more of these options.
Typically, this is done in the \code{.Rprofile} startup file, with code along
these lines:\preformatted{options(
  gargle_oauth_email = "jane@example.com",
  gargle_oauth_cache = "/path/to/folder/that/does/not/sync/to/cloud"
)
}
}
\section{\code{gargle_oauth_email}}{

\code{gargle_oauth_email()} returns the option named "gargle_oauth_email", which
is undefined by default. If set, this option should be one of:
\itemize{
\item An actual email address corresponding to your preferred Google identity.
Example:\code{janedoe@gmail.com}.
\item \code{TRUE} to allow email and OAuth token auto-discovery, if exactly one
suitable token is found in the cache.
\item \code{FALSE} or \code{NA} to force the OAuth dance in the browser.
}
}

\section{\code{gargle_oob_default}}{

\code{gargle_oob_default()} returns the option named "gargle_oob_default", falls
back to the option named "httr_oob_default", and eventually defaults to
\code{FALSE}. This controls whether to prefer "out of band" authentication. We
also return \code{FALSE} unconditionally on RStudio Server or Cloud. This value is
ultimately passed to \code{\link[httr:init_oauth2.0]{httr::init_oauth2.0()}} as \code{use_oob}. If \code{FALSE} (and
httpuv is installed), a local webserver is used for the OAuth dance.
Otherwise, user gets a URL and prompt for a validation code.

Read more about "out of band" authentication in the vignette \href{https://gargle.r-lib.org/articles/auth-from-web.html}{Auth when using R in the browser}.
}

\section{\code{gargle_oauth_cache}}{

\code{gargle_oauth_cache()} returns the option named "gargle_oauth_cache",
defaulting to \code{NA}. If defined, the option must be set to a logical value or
a string. \code{TRUE} means to cache using the default user-level cache file,
\verb{~/.R/gargle/gargle-oauth}, \code{FALSE} means don't cache, and \code{NA} means to
guess using some sensible heuristics.
}

\section{\code{gargle_verbosity}}{

\code{gargle_verbosity()} returns the option named "gargle_verbosity", which
determines gargle's verbosity. There are three possible values, inspired by
the logging levels of log4j:
\itemize{
\item "debug": Fine-grained information helpful when debugging, e.g. figuring out
how \code{token_fetch()} is working through the registry of credential
functions. Previously, this was activated by setting an option named
"gargle_quiet" to \code{FALSE}.
\item "info" (default): High-level information that a typical user needs to see.
Since typical gargle usage is always indirect, i.e. gargle is called by
another package, gargle itself is very quiet. There are very few messages
emitted when \code{gargle_verbosity = "info"}.
\item "silent": No messages at all. However, warnings or errors are still thrown
normally.
}
}

\examples{
gargle_oauth_email()
gargle_oob_default()
gargle_oauth_cache()
gargle_verbosity()
}
