      SUBROUTINE RDCORR(IC,IQ,JEQNO,JTEM)
C
C READS CORRELATIONS FROM JOBFILE (OUTPUT FROM PATH1A)
C CALLS POOLJS TO POOL CORRELATIONS AND WRITE HETEROGENEITY TABLE
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C  DESCRIPTION OF ESSENTIAL VARIABLES IN COMMON /CORDAT/
C
C  NCARD  = NUMBER OF INPUT CORRELATIONS WITH DIFFERENT EXPECTATIONS
C  NEQ()  = EQUATION NUMBER PROGRAMMED INTO FUNCTION SUBROUTINE
C  REXP() = EXPECTED RHO
C  ROBS() = OBSERVED RHO
C  QNN()  = SAMPLE SIZE
C  CHI()  = CHI SQUARE
C  ESP()  = SPECIFIC EFFECT (0.0 IF NOT PRESENT)
C  DESC() = DESCRIPTIONS AS FOUND IN EQNO FILE
C
      PARAMETER (MXC=60)
      COMMON /CORDAT1/ ROBS(MXC),REXP(MXC),QNN(MXC),
     +                 CHI(MXC),ESP(MXC),NEQ(MXC),NCARD
      CHARACTER   DESC*45
      COMMON /CORDA2/ DESC(MXC)
C
C READ UN-POOLED CORRELATIONS FROM THE JOB FILE
C
      NCARD = 0
      DO 100 I=1,100
         READ (IC,*,END=110,ERR=110) NEQ(I),ROBS(I),QNN(I),ESP(I)
         NCARD = I
100   CONTINUE
110   CONTINUE
C
C POOL CORRELATIONS
C
      CALL POOLJS(IQ,JEQNO,JTEM)
      IF (NCARD .EQ. 0) STOP 'NO DATA'
C
      RETURN
      END
      SUBROUTINE POOLJS(IQ,JEQNO,JTEM)
C
C POOLS ALL CORRELATIONS IN /CORDAT1/ WITH MATCHING EQUATION
C NUMBERS, AND WRITES HETEROGENEITY TABLE TO TERSE FILE
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER   TEMP*45
C
C  DESCRIPTION OF ESSENTIAL VARIABLES IN COMMON /CORDAT/
C
C  NCARD  = NUMBER OF INPUT CORRELATIONS WITH DIFFERENT EXPECTATIONS
C  NEQ()  = EQUATION NUMBER PROGRAMMED INTO FUNCTION SUBROUTINE
C  REXP() = EXPECTED RHO
C  ROBS() = OBSERVED RHO
C  QNN()  = SAMPLE SIZE
C  CHI()  = CHI SQUARE
C  ESP()  = SPECIFIC EFFECT (0.0 IF NOT PRESENT)
C  DESC() = DESCRIPTIONS AS FOUND IN EQNO FILE
C
      PARAMETER (MXC=60)
      COMMON /CORDAT1/ ROBS(MXC),REXP(MXC),QNN(MXC),
     +                 CHI(MXC),ESP(MXC),NEQ(MXC),NCARD
      CHARACTER   DESC*45
      COMMON /CORDA2/ DESC(MXC)
C
C INITIALIZE EQUATION NUMBERS FILE AND TEMPORARY WORK FILE
C
      REWIND JEQNO
      CALL ADVREC(JEQNO,3)
      REWIND JTEM
C
C GET THE DESCRIPTION FOR EACH CORRELATION FROM THE EQNO FILE
C
      DO 210 I=1,NCARD
         DESC(I) = '<NO DESCRIPTION>'
210   CONTINUE
C
220   CONTINUE
         READ (JEQNO,'(I4,5X,A)',END=290) JEQ,TEMP
         DO 230 I=1,NCARD
            IF (NEQ(I) .EQ. JEQ) DESC(I) = TEMP
230      CONTINUE
      GO TO 220
290   CONTINUE
C
C WRITE TERSE AND TEMPORARY FILE HEADINGS
C
      WRITE (IQ,1010)
      WRITE (IQ,1020)
      WRITE (IQ,1030)
      WRITE (IQ,1040)
      WRITE (IQ,1020)
C
      WRITE (JTEM,1050)
      WRITE (JTEM,1020)
C
 1010 FORMAT (27X,'* * * HETEROGENEITY CHI-2 AMONG ',
     +                   'MULTIPLE ESTIMATES * * *'/)
 1020 FORMAT (1X,102('*'))
 1030 FORMAT (75X,        'HETEROGENEITY CHI-2')
 1040 FORMAT ('  EQ. DESCRIPTION',40X,4X,'R',7X,'N',6X,
     +                   'USING R   USING Z      D.F.')
 1050 FORMAT ('  EQ. DESCRIPTION',40X,'R',7X,'N',4X,'SP. EFF.')
C
C POOL ALL CORRELATIONS WITH MATCHING EQUATION NUMBERS
C
      CZ = 0.
      CR = 0.
      NDF= 0
      DO 320 I=1,NCARD
         IF (NEQ(I) .GT. 0) THEN
            CHIZ = 0.
            CHIR = 0.
            ND = 0
            DO 310 J=I+1,NCARD
               IF (NEQ(I) .EQ. NEQ(J)) THEN
                  PR1 = ROBS(I)
                  PR2 = ROBS(J)
                  PN1 = QNN(I)
                  PN2 = QNN(J)
C
                  CALL POOL(PR1,PN1,PR2,PN2,ROBS(I),QNN(I),C1,C2)
C
                  CHIZ = CHIZ + C1
                  CHIR = CHIR + C2
                  ND = ND + 1
C
                  NEQ(J) = 0
               END IF
310         CONTINUE
            CZ = CZ + CHIZ
            CR = CR + CHIR
            NDF = NDF + ND
C
            WRITE (IQ,1310) NEQ(I),DESC(I),ROBS(I),QNN(I),CHIR,CHIZ,ND
            WRITE (JTEM,1320) NEQ(I),DESC(I),ROBS(I),QNN(I),ESP(I)
 1310       FORMAT (I5,1X,A,4X,F10.4,F8.2,2F10.3,I9)
 1320       FORMAT (I5,1X,A,F10.4,F8.2,F6.2)
         END IF
320   CONTINUE
C
      WRITE (IQ,1020)
      WRITE (IQ,1400) CZ,CR,NDF
      WRITE (IQ,1020)
C
 1400 FORMAT (/' ','TOTAL HETEROGENEITY:',52X,2F10.3,I9,/)
C
      ENDFILE JTEM
C
C COMPRESS CORDAT
C
      ICARD = 0
      DO 500 I=1,NCARD
         IF (NEQ(I) .GT. 0) THEN
            ICARD = ICARD + 1
            IF (I .GT. ICARD) THEN
               NEQ(ICARD)  = NEQ(I)
               ROBS(ICARD) = ROBS(I)
               QNN(ICARD)  = QNN(I)
               ESP(ICARD)  = ESP(I)
               DESC(ICARD) = DESC(I)
            END IF
         END IF
500   CONTINUE
      NCARD = ICARD
C
      RETURN
      END
      SUBROUTINE POOL(R1,N1,R2,N2,RR,NN,CHIZ,CHIR)
C
C POOLS TWO CORRELATIONS:
C
C     INPUT:   R1, R2 = CORRELATIONS BEING POOLED
C              N1, N2 = SAMPLE SIZES OF THE INDIVIDUAL CORRELATIONS
C
C     OUTPUT : RR  = POOLED CORRELATION
C              NN  = SAMPLE SIZE FOR THE POOLED CORRELATION
C              CHI = HETEROGENEITY CHI-SQUARE
C
      IMPLICIT DOUBLE PRECISION (A-Z)
      data z1,z2,zz /3*0./
C
      NN = N1 + N2
      IF ((NN.GT.0) .AND. (R1.LT.1.0 .AND. R2.LT.1.0)) THEN
         Z1 = .5*LOG( (1.+R1) / (1.-R1) )
         Z2 = .5*LOG( (1.+R2) / (1.-R2) )
         ZZ = (N1*Z1 + N2*Z2) / NN
         RR = (EXP(2.*ZZ)-1.) / (EXP(2.*ZZ)+1.)
      ELSE
         RR   = 0.0
      END IF
C
      CHIR = N1*(R1-RR)*(R1-RR)/((1.-RR*RR)*(1.-RR*RR)) +
     +       N2*(R2-RR)*(R2-RR)/((1.-RR*RR)*(1.-RR*RR))
C
      CHIZ = N1*(Z1-ZZ)*(Z1-ZZ) +
     +       N2*(Z2-ZZ)*(Z2-ZZ)
C
      RETURN
      END
