% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdGenerate.R
\name{gdGenerate}
\alias{gdGenerate}
\title{Generate generative data for a data source}
\usage{
gdGenerate(
  generativeDataFileName,
  generativeModelFileName,
  generateParameters = gdGenerateParameters(numberOfSamples = 10000, dropout = 0.05)
)
}
\arguments{
\item{generativeDataFileName}{Name of generative data file}

\item{generativeModelFileName}{Name of generative model file}

\item{generateParameters}{Generation of generative data parameters, see
function gdGenerateParameters().}
}
\value{
None
}
\description{
Read a trained generative model for a data source, generate generative data
and write generated data to a file in binary format.
}
\examples{
\dontrun{
generateParameters <- gdGenerateParameters(numberOfSamples = 10000)
gdGenerate("gd.bin", "gm.bin", generateParameters)}
}
