% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah-package.R
\docType{package}
\name{galah}
\alias{galah}
\alias{galah-package}
\title{Biodiversity Data from the GBIF Node Network}
\description{
The Global Biodiversity Information Facility (GBIF; \url{https://www.gbif.org})
provides tools to enable users to find, access, combine and visualise
biodiversity data. \code{galah} enables the R community to directly access data and
resources hosted by GBIF and several of it's subsidiary organisations, known
as 'nodes'. The basic unit of observation stored by these infrastructures is
an \strong{occurrence} record, based on the Darwin Core' data standard
(\url{https://dwc.tdwg.org}); however \code{galah} also enables users to locate and
download taxonomic information, or associated media such images or sounds,
all while restricting their queries to particular taxa or locations. Users
can specify which columns are returned by a query, or restrict their results
to observations that meet particular quality-control criteria.

For those outside Australia, 'galah' is the common name of
\emph{Eolophus roseicapilla}, a widely-distributed Australian bird species.
}
\section{Functions}{

\strong{Piping functions}
\itemize{
\item \code{\link[=galah_call]{galah_call()}} or \code{\link[=request_data]{request_()}} et al.  Start to build a data query
\item \code{\link[=collapse_galah]{collapse()}} Generate a query
\item \code{\link[=compute_galah]{compute()}} Compute a query
\item \code{\link[=collect_galah]{collect()}} Retrieve a database query
}

\strong{Lazy data manipulation}
\itemize{
\item \code{\link[=identify.data_request]{identify()}} or \code{\link[=galah_identify]{galah_identify()}} Search for taxonomic identifiers
\item \code{\link[=filter.data_request]{filter()}} or \code{\link[=galah_filter]{galah_filter()}}Filter records
\item \code{\link[=select.data_request]{select()}} or \code{\link[=galah_select]{galah_select()}}Fields to report information for
\item \code{\link[=group_by.data_request]{group_by()}} or \code{\link[=galah_group_by]{galah_group_by()}} Fields to group counts by
\item \code{\link[=st_crop.data_request]{st_crop()}} or \code{\link[=galah_geolocate]{galah_geolocate()}} Specify a location
\item \code{\link[=apply_profile]{apply_profile()}} or \code{\link[=galah_apply_profile]{galah_apply_profile()}} Restrict to data that pass predefined checks (ALA only)
\item \code{\link[=slice_head.data_request]{slice_head()}} Choose the first n rows of a download
\item \code{\link[=arrange.data_request]{arrange()}} Arrange rows of a query on the server side
}

\strong{Download data}
\itemize{
\item \code{\link[=atlas_occurrences]{atlas_occurrences()}} Download occurrence records
\item \code{\link[=atlas_counts]{atlas_counts()}} or \code{\link[=count.data_request]{count()}} Count the number of records or species returned by a query
\item \code{\link[=atlas_species]{atlas_species()}} Download species lists
\item \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} Return a section of the ALA taxonomic tree
\item \code{\link[=atlas_media]{atlas_media()}} View images and sounds available to download
\item \code{\link[=collect_media]{collect_media()}} Download images and sounds
}

\strong{Look up information}
\itemize{
\item \code{\link[=search_taxa]{search_taxa()}} Search for taxa using a text-search
\item \code{\link[=search_identifiers]{search_identifiers()}} Search for taxa using taxonomic identifiers
\item \code{\link[=show_all]{show_all()}} & \code{\link[=search_all]{search_all()}} Data for generating filter queries
\item \code{\link[=show_values]{show_values()}} & \code{\link[=search_values]{search_values()}} Show or search for values \emph{within}
\code{fields}, \code{profiles}, \code{lists}, \code{collections}, \code{datasets} or \code{providers}
}

\strong{Configure session}
\itemize{
\item \code{\link[=galah_config]{galah_config()}} Package configuration options
}

\strong{Cite}
\itemize{
\item \code{\link[=atlas_citation]{atlas_citation()}} Citation for a dataset
}
}

\section{Terminology}{


To get the most value from \code{galah}, it is helpful to understand some
terminology. Each occurrence record contains taxonomic
information, and usually some information about the observation itself, such
as its location. In addition to this record-specific information, the living
atlases append contextual information to each record, particularly data from
spatial \strong{layers} reflecting climate gradients or political boundaries. They
also run a number of quality checks against each record, resulting in
\strong{assertions} attached to the record. Each piece of information
associated with a given occurrence record is stored in a \strong{field},
which corresponds to a \strong{column} when imported to an
\verb{R data.frame}. See \code{show_all(fields)} to view valid fields,
layers and assertions, or conduct a search using \code{search_all(fields)}.

Data fields are important because they provide a means to \strong{filter}
occurrence records;  i.e. to return only the information that you need, and
no more. Consequently, much of the architecture of \code{galah} has been
designed to make filtering as simple as possible. The easiest way to do this
is to start a pipe with \code{galah_call()} and follow it with the relevant
\code{dplyr} function; starting with \code{filter()}, but also including \code{select()},
\code{group_by()} or others. Functions without a relevant \code{dplyr} synonym include
\code{\link[=galah_identify]{galah_identify()}}/\code{identify()} for choosing a taxon, or \code{\link[=galah_geolocate]{galah_geolocate()}}/
\code{st_crop()} for choosing a specific location. By combining different filters,
it is possible to build complex queries to return only the most valuable
information for a given problem.

A notable extension of the filtering approach is to remove records with low
'quality'. All living atlases perform quality control checks on all records
that they store. These checks are used to generate new fields, that can then
be used to filter out records that are unsuitable for particular applications.
However, there are many possible data quality checks, and it is not always
clear which are most appropriate in a given instance. Therefore, \code{galah}
supports data quality \strong{profiles}, which can be passed to
\code{\link[=galah_apply_profile]{galah_apply_profile()}} to quickly remove undesirable records. A full list of
data quality profiles is returned by \code{show_all(profiles)}. Note this service
is currently only available for the Australian atlas (ALA).
}

\seealso{
Useful links:
\itemize{
  \item \url{https://galah.ala.org.au/R/}
  \item Report bugs at \url{https://github.com/AtlasOfLivingAustralia/galah-R/issues}
}

}
\author{
\strong{Maintainer}: Martin Westgate \email{martin.westgate@csiro.au}

Authors:
\itemize{
  \item Matilda Stevenson
  \item Dax Kellie \email{dax.kellie@csiro.au}
  \item Peggy Newman \email{peggy.newman@csiro.au}
}

}
\keyword{internal}
