% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_identify.R
\name{galah_identify}
\alias{galah_identify}
\alias{identify.data_request}
\alias{identify.metadata_request}
\title{Narrow a query by passing taxonomic identifiers}
\usage{
galah_identify(..., search = NULL)

\method{identify}{data_request}(x, ...)

\method{identify}{metadata_request}(x, ...)
}
\arguments{
\item{...}{One or more scientific names.}

\item{search}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\code{galah_identify()} now always does a search to verify search terms; ergo
this argument is ignored.}

\item{x}{An object of class \code{metadata_request}, created using \code{\link[=request_metadata]{request_metadata()}}}
}
\value{
A tibble containing identified taxa.
}
\description{
When conducting a search or creating a data query, it is common to identify
a known taxon or group of taxa to narrow down the records or results returned.
}
\details{
\code{galah_identify()} is used to identify taxa you want returned in a search or
a data query. Users to pass scientific names or taxonomic identifiers
with pipes to provide data only for the biological group of interest.

It is good to use \code{\link[=search_taxa]{search_taxa()}} and \code{\link[=search_identifiers]{search_identifiers()}}
first to check that the taxa you provide to \code{galah_identify()} return the
correct results.
}
\examples{
\dontrun{
# Specify a taxon. A valid taxon will return an identifier.
galah_identify("reptilia")

# Specify more than one taxon at a time.
galah_identify("reptilia", "mammalia", "aves", "pisces")

# Use `galah_identify()` to narrow your queries
galah_call() |> 
  galah_identify("Eolophus") |>
  atlas_counts()

# Within a pipe, `identify()` and `galah_identify()` are synonymous.
# hence the following is identical to the previous example:
request_data() |>
  identify("Eolophus") |>
  count() |>
  collect()

# If you know a valid taxon identifier, use `galah_filter()` instead.
# (This was formerly supported by `galah_identify()` with `search = FALSE`)
id <- "https://biodiversity.org.au/afd/taxa/009169a9-a916-40ee-866c-669ae0a21c5c"
galah_call() |> 
  galah_filter(lsid == id) |>
  atlas_counts()
}
}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} to find identifiers from scientific names;
\code{\link[=search_identifiers]{search_identifiers()}} for how to get names if taxonomic identifiers
are already known.
}
