% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/List.R
\docType{class}
\name{List-class}
\alias{List}
\alias{List-class}
\title{A list extension class.}
\arguments{
\item{...}{passed to constructor}
}
\description{
Like a list, but has some methods. Completely superflous, but
makes copying some code algorithms easier. We implement methods
such as \code{append}, \code{push}, \code{pop} and \code{each} for
iteration. As well, there are some lookup methods.
}
\section{Methods}{

\describe{
\item{\code{contains(name)}}{TRUE if name is key in array}

\item{\code{core()}}{return list}

\item{\code{each(FUN, ...)}}{Iterator for lists, like sapply, but FUN gets passed index, key, and value}

\item{\code{flush(...)}}{Reset array, return contents as list}

\item{\code{get_by_name(name)}}{get item under name}

\item{\code{get_id()}}{Return an id, or name, for an object}

\item{\code{get_item(index)}}{Get item by index}

\item{\code{insert(x, name, index)}}{Insert item into List with 0 the head and index=len() the tail}

\item{\code{len()}}{length}

\item{\code{pluck(id, FUN, ...)}}{Like ext.pluck. Returns array with 'id' extracted from each item in the List}

\item{\code{pop()}}{pop last element of list}

\item{\code{push(x, name)}}{Append x with optional name. If name not specified new id created. Returns name}
}}

