% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_array_simulate.R
\name{array-simulate}
\alias{array-simulate}
\alias{simulateArray}
\alias{simulate.table}
\alias{simulate.xtabs}
\alias{simulate.array}
\title{Simulate data from array.}
\usage{
simulateArray(x, nsim = 1, margin, value.margin, seed = NULL)

\method{simulate}{table}(object, nsim = 1, seed = NULL, margin, value.margin, ...)

\method{simulate}{xtabs}(object, nsim = 1, seed = NULL, margin, value.margin, ...)

\method{simulate}{array}(object, nsim = 1, seed = NULL, margin, value.margin, ...)
}
\arguments{
\item{x, object}{An array.}

\item{nsim}{Number of cases to simulate.}

\item{margin, value.margin}{Specification of slice of array to
simulate from.}

\item{seed}{Seed to be used for random number generation.}

\item{...}{Additional arguments, currently not used.}
}
\value{
A matrix.
}
\description{
Simulate data (slice of) an array: Simulate n
observations from the array x conditional on the variables in
margin (a vector of indices) takes values given by margin.value
}
\note{
The current implementation is fragile in the sense that it is
not checked that the input argument \code{x} is an array.
}
\examples{
## 2x2 array
x <- parray(c("a", "b"), levels=c(2, 2), values=1:4)

## Simulate from entire array
s <- simulateArray(x, 1000)
xtabs(~., as.data.frame(s))

## Simulate from slice defined by that dimension 1 is fixed at level 2
s <-simulateArray(x, 6000, 1, 2)
xtabs(~., as.data.frame(s))

## 2 x 2 x 2 array
x <- parray(c("a", "b", "c"), levels=c(2, 2, 2), values=1:8)
## Simulate from entire array
s <-simulateArray(x, 36000)
xtabs(~., as.data.frame(s))

## Simulate from slice defined by that dimension 3 is fixed at level 1
s <-simulateArray(x, 10000, 3, 1)
xtabs(~., as.data.frame(s))


}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
