% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov2pcor.R
\name{cov2pcor}
\alias{cov2pcor}
\alias{conc2pcor}
\title{Partial correlation (matrix)}
\usage{
cov2pcor(V)

conc2pcor(K)
}
\arguments{
\item{V}{Covariance matrix}

\item{K}{Concentration matrix}
}
\value{
A matrix with the same dimension as V.
}
\description{
\code{cov2pcor} calculates the partial correlation
    matrix from an (empirical) covariance matrix while
    \code{conc2pcor} calculates the partial correlation matrix from
    a concentration matrix (inverse covariance matrix).
}
\examples{

data(math)
S <- cov.wt(math)$cov
cov2pcor(S)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
