/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.af.commons.errorhandling.DefaultExceptionHandler;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.tools.OSTools;
import org.af.commons.widgets.InfiniteProgressPanel;
import org.af.commons.widgets.WidgetFactory;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.config.VersionComparator;
import org.af.gMCP.gui.JSplitPaneBugWorkAround;
import org.af.gMCP.gui.MenuBarMGraph;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.dialogs.TellAboutOnlineUpate;
import org.af.gMCP.gui.graph.DView;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.PView;
import org.af.gMCP.gui.options.OptionsDialog;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rosuda.REngine.JRI.JRIEngine;

public class CreateGraphGUI
extends JFrame
implements WindowListener,
InfiniteProgressPanel.AbortListener {
    GraphView control;
    PView pview;
    DView dview;
    public DataFramePanel dfp;
    public InfiniteProgressPanel glassPane;
    protected static Log logger;
    public static CreateGraphGUI lastCreatedGUI;
    public static int countGUIs;
    public static String helpURL;
    static String graphStr;
    static boolean debug;
    static double grid;
    JSplitPaneBugWorkAround splitPane;
    JSplitPaneBugWorkAround splitPane1;
    JSplitPaneBugWorkAround splitPane2;

    public CreateGraphGUI(String graph, double[] pvalues, boolean debug, double grid, boolean experimentalFeatures) {
        super("gMCP GUI");
        ++countGUIs;
        System.setProperty("java.net.useSystemProxies", "true");
        RControl.getRControl(debug);
        if (grid > 0.0) {
            Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        }
        Configuration.getInstance().getGeneralConfig().setExperimental(experimentalFeatures);
        if (System.getProperty("eclipse") != null) {
            helpURL = "http://algorithm-forge.com/gMCP/archive/gMCP.pdf";
        }
        try {
            Configuration.getInstance().getGeneralConfig().setRVersionNumber(RControl.getR().eval("paste(R.version$major,R.version$minor,sep=\".\")").asRChar().getData()[0]);
            Configuration.getInstance().getGeneralConfig().setVersionNumber(RControl.getR().eval("gMCP:::gMCPVersion()").asRChar().getData()[0]);
            this.setTitle("gMCP GUI " + Configuration.getInstance().getGeneralConfig().getVersionNumber());
            Configuration.getInstance().getGeneralConfig().setReleaseDate(RControl.getR().eval("packageDescription(\"gMCP\", fields=\"Date/Publication\")").asRChar().getData()[0]);
        }
        catch (Exception e) {
            logger.warn((Object)("Package version could not be set:\n" + e.getMessage()));
        }
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultExceptionHandler());
        int n = Configuration.getInstance().getGeneralConfig().getNumberOfStarts();
        Configuration.getInstance().getGeneralConfig().setNumberOfStarts(n + 1);
        logger.info((Object)("gMCP start No. " + n + 1));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/af/gMCP/gui/graph/images/rjavaicon64.png")).getImage());
        try {
            this.setLooknFeel();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "Font size and Look'n'Feel could not be restored.", "Error restoring Look'n'Feel", 0);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.dview = new DView(this);
        this.dfp = new DataFramePanel(new RDataFrameRef());
        this.control = new GraphView(graph, this);
        this.dfp.registerControl(this.control);
        this.pview = new PView(this);
        this.setJMenuBar(new MenuBarMGraph(this.control));
        this.makeContent();
        if (RControl.getR().eval("exists(\"" + graph + "\"" + Configuration.getInstance().getGeneralConfig().getEnvir() + ")", true).asRLogical().getData()[0]) {
            this.control.getNL().loadGraph(graph, true);
        }
        if (System.getProperty("eclipse") != null) {
            ((MenuBarMGraph)this.getJMenuBar()).loadGraph("HungEtWang2010()", false);
        }
        if (pvalues.length > 0) {
            this.getPView().setPValues(ArrayUtils.toObject((double[])pvalues));
        }
        this.glassPane = new InfiniteProgressPanel((JFrame)this, "Calculating");
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.addAbortListener((InfiniteProgressPanel.AbortListener)this);
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setExtendedState(this.getExtendedState() | 6);
        this.setVisible(true);
        this.splitPane1.setDividerLocation(0.75);
        this.splitPane2.setDividerLocation(0.5);
        this.splitPane1.setResizeWeight(0.75);
        this.splitPane2.setResizeWeight(0.5);
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 6; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)("Interrupted: " + e.getMessage()), (Throwable)e);
                    }
                    CreateGraphGUI.this.splitPane1.setDividerLocation(0.75);
                    CreateGraphGUI.this.splitPane2.setDividerLocation(0.5);
                }
            }
        }).start();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!Configuration.getInstance().getGeneralConfig().tellAboutCheckOnline()) {
                    new TellAboutOnlineUpate(null);
                    Configuration.getInstance().getGeneralConfig().setTellAboutCheckOnline(true);
                }
                new Thread(new Runnable(){

                    public void run() {
                        VersionComparator.getOnlineVersion();
                    }
                }).start();
            }
        });
        lastCreatedGUI = this;
    }

    public static void startGUI(String graphStr, boolean debug, double grid) {
        CreateGraphGUI.graphStr = graphStr;
        CreateGraphGUI.debug = debug;
        CreateGraphGUI.grid = grid;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CreateGraphGUI(graphStr, new double[0], debug, grid, true);
            }
        });
    }

    private void makeContent() {
        this.splitPane1 = new JSplitPaneBugWorkAround(0, this.control, this.dview);
        this.splitPane2 = new JSplitPaneBugWorkAround(0, new JScrollPane(this.dfp), new JScrollPane(this.pview));
        this.splitPane = new JSplitPaneBugWorkAround(1, this.splitPane1, this.splitPane2);
        this.getContentPane().add(this.splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", new double[0], true, 50.0, true);
    }

    public void windowClosing(WindowEvent e) {
        if (!this.control.isGraphSaved && Configuration.getInstance().getGeneralConfig().askWhenGraphIsNotSaved()) {
            int answer = JOptionPane.showConfirmDialog(this, "The current graph is not saved yet!\nDo you want to save it?", "Do you want to save the graph?", 1, 2);
            if (answer == 2) {
                return;
            }
            if (answer == 0) {
                this.control.saveGraph();
            }
        }
        if (--countGUIs == 0) {
            // empty if block
        }
        if (RControl.getR().eval("exists(\".isBundle\")").asRLogical().getData()[0]) {
            RControl.getR().eval("q(save=\"no\")");
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }

    public GraphView getGraphView() {
        return this.control;
    }

    public MenuBarMGraph getMBar() {
        return (MenuBarMGraph)this.getJMenuBar();
    }

    public void abort() {
        if (RControl.getR().getREngine().getClass() == JRIEngine.class) {
            JRIEngine engine = (JRIEngine)RControl.getR().getREngine();
            engine.getRni().rniStop(0);
            try {
                RControl.getR().eval("mvtnorm::rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.warn((Object)("There was an error in the test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
            }
            try {
                RControl.getR().eval("mvtnorm::rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.error((Object)("There was an error in the 2. test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
                String message = "There was an error interrupting the R calculation.\nAfter you press okay an error dialog will open and please inform us about this.\nAfter that we recommend that you close the GUI (but you can try whether saving of graphs or other things work).";
                JOptionPane.showMessageDialog(this, message, "Error interrupting R calculation", 0);
                ErrorHandler.getInstance().makeErrDialog("");
            }
        } else {
            logger.error((Object)("Could not stop REngine of class '" + RControl.getR().getREngine().getClass() + "'"));
        }
    }

    public DView getDView() {
        return this.dview;
    }

    public DataFramePanel getDataFramePanel() {
        return this.dfp;
    }

    private void setLooknFeel() throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(Configuration.getInstance().getJavaConfig().getLooknFeel());
        WidgetFactory.setFontSizeGlobal((int)Configuration.getInstance().getGeneralConfig().getFontSize());
        SwingUtilities.updateComponentTreeUI(this);
    }

    public int getLayerNr() {
        return this.getGraphView().getNumberOfLayers();
    }

    public void openHelp(String topic) {
        if (Configuration.getInstance().getGeneralConfig().showOnlineHelp()) {
            this.getMBar().showURL(helpURL + "#nameddest=" + topic);
        } else {
            String manual = "doc/gMCP.pdf";
            File f = new File(RControl.getR().eval("system.file(\"" + manual + "\", package=\"gMCP\")").asRChar().getData()[0]);
            String pdfViewerPath = Configuration.getInstance().getGeneralConfig().getPDFViewerPath();
            if (pdfViewerPath.equals("not configured")) {
                int answer = JOptionPane.showConfirmDialog(this, "PDF viewer not configured.\nDo you want to open the options\nto select the PDF viewer?", "PDF viewer not set", 0);
                if (answer == 0) {
                    new OptionsDialog(this, "Misc");
                    this.dispose();
                    return;
                }
                return;
            }
            String parameter = "";
            if (pdfViewerPath.toLowerCase().contains("acro")) {
                parameter = "nameddest=" + topic + "";
            }
            String cmdString = "\"" + pdfViewerPath + "\" /A \"" + parameter + "\" \"" + f.getAbsolutePath() + "\"";
            String[] cmdarray = new String[]{pdfViewerPath, f.getAbsolutePath()};
            if (!parameter.isEmpty()) {
                cmdarray = new String[]{pdfViewerPath, "/A", parameter, f.getAbsolutePath()};
            }
            try {
                if (OSTools.isWindows()) {
                    System.out.println("Starting: " + cmdString);
                    Process p = Runtime.getRuntime().exec(cmdString);
                } else {
                    Process p = Runtime.getRuntime().exec(cmdarray);
                }
            }
            catch (IOException e) {
                ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e, false);
                e.printStackTrace();
            }
        }
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        JComponent.setDefaultLocale(Locale.ENGLISH);
        logger = LogFactory.getLog(CreateGraphGUI.class);
        countGUIs = 0;
        helpURL = "http://cran.r-project.org/web/packages/gMCP/vignettes/gMCP.pdf";
    }
}

