/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.InfiniteProgressPanel;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.config.VersionComparator;
import org.af.gMCP.gui.JSplitPaneBugWorkAround;
import org.af.gMCP.gui.MenuBarMGraph;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.DataTable;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.graph.DView;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.PView;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rosuda.REngine.JRI.JRIEngine;

public class CreateGraphGUI
extends JFrame
implements WindowListener,
InfiniteProgressPanel.AbortListener {
    GraphView agc;
    PView pview;
    DView dview;
    DataFramePanel dfp;
    public InfiniteProgressPanel glassPane;
    protected static Log logger = LogFactory.getLog(CreateGraphGUI.class);
    static String graphStr;
    static boolean debug;
    static double grid;
    JSplitPaneBugWorkAround splitPane;
    JSplitPaneBugWorkAround splitPane1;
    JSplitPaneBugWorkAround splitPane2;

    public CreateGraphGUI(String graph, double[] pvalues, boolean debug, double grid, boolean experimentalFeatures) {
        super("gMCP GUI");
        Locale.setDefault(Locale.US);
        JComponent.setDefaultLocale(Locale.US);
        RControl.getRControl(debug);
        Localizer.getInstance().addResourceBundle("org.af.gMCP.gui.ResourceBundle");
        if (grid > 0.0) {
            Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        }
        Configuration.getInstance().getGeneralConfig().setExperimental(experimentalFeatures);
        try {
            Configuration.getInstance().getGeneralConfig().setRVersionNumber(RControl.getR().eval("paste(R.version$major,R.version$minor,sep=\".\")").asRChar().getData()[0]);
            Configuration.getInstance().getGeneralConfig().setVersionNumber(RControl.getR().eval("gMCP:::gMCPVersion()").asRChar().getData()[0]);
            this.setTitle("gMCP GUI " + Configuration.getInstance().getGeneralConfig().getVersionNumber());
        }
        catch (Exception e) {
            logger.warn((Object)("Package version could not be set:\n" + e.getMessage()));
        }
        int n = Configuration.getInstance().getGeneralConfig().getNumberOfStarts();
        Configuration.getInstance().getGeneralConfig().setNumberOfStarts(n + 1);
        logger.info((Object)("gMCP start No. " + n + 1));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/af/gMCP/gui/graph/images/rjavaicon64.png")).getImage());
        this.addWindowListener(this);
        this.pview = new PView(this);
        this.dview = new DView(this);
        this.dfp = new DataFramePanel(new RDataFrameRef());
        this.agc = new GraphView(graph, this);
        this.setJMenuBar(new MenuBarMGraph(this.agc));
        this.makeContent();
        if (RControl.getR().eval("exists(\"" + graph + "\")").asRLogical().getData()[0]) {
            this.agc.getNL().loadGraph(graph);
        }
        if (pvalues.length > 0) {
            this.getPView().setPValues(ArrayUtils.toObject((double[])pvalues));
        }
        this.glassPane = new InfiniteProgressPanel((JFrame)this, "Calculating");
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.addAbortListener((InfiniteProgressPanel.AbortListener)this);
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setVisible(true);
        this.splitPane1.setDividerLocation(0.75);
        this.splitPane2.setDividerLocation(0.5);
        this.splitPane1.setResizeWeight(0.75);
        this.splitPane2.setResizeWeight(0.5);
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 6; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)("Interrupted: " + e.getMessage()), (Throwable)e);
                    }
                    CreateGraphGUI.this.splitPane1.setDividerLocation(0.75);
                    CreateGraphGUI.this.splitPane2.setDividerLocation(0.5);
                }
            }
        }).start();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VersionComparator.getOnlineVersion();
            }
        });
    }

    public static void startGUI(String graphStr, boolean debug, double grid) {
        CreateGraphGUI.graphStr = graphStr;
        CreateGraphGUI.debug = debug;
        CreateGraphGUI.grid = grid;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CreateGraphGUI(graphStr, new double[0], debug, grid, true);
            }
        });
    }

    private void makeContent() {
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(this.agc));
        this.splitPane1 = new JSplitPaneBugWorkAround(0, this.agc, this.dview);
        this.splitPane2 = new JSplitPaneBugWorkAround(0, new JScrollPane(this.dfp), new JScrollPane(this.pview));
        this.splitPane = new JSplitPaneBugWorkAround(1, this.splitPane1, this.splitPane2);
        this.getContentPane().add(this.splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", new double[0], true, 10.0, true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }

    public GraphView getGraphView() {
        return this.agc;
    }

    public DataTable getDataTable() {
        return this.dfp.getTable();
    }

    public void abort() {
        if (RControl.getR().getREngine().getClass() == JRIEngine.class) {
            JRIEngine engine = (JRIEngine)RControl.getR().getREngine();
            engine.getRni().rniStop(0);
            try {
                RControl.getR().eval("rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.warn((Object)("There was an error in the test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
            }
            try {
                RControl.getR().eval("rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.error((Object)("There was an error in the 2. test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
                String message = "There was an error interrupting the R calculation.\nAfter you press okay an error dialog will open and please inform us about this.\nAfter that we recommend that you close the GUI (but you can try whether saving of graphs or other things work).";
                JOptionPane.showMessageDialog(this, message, "Error interrupting R calculation", 0);
                ErrorHandler.getInstance().makeErrDialog("");
            }
        } else {
            logger.error((Object)("Could not stop REngine of class '" + RControl.getR().getREngine().getClass() + "'"));
        }
    }

    public DView getDView() {
        return this.dview;
    }
}

