/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import org.mutoss.gui.CreateGraphGUI;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.RejectedDialog;

public class CorrelatedTest
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    JRadioButton jrbNoCorrelation = new JRadioButton("No Information about correlations");
    JRadioButton jrbStandardCorrelation = new JRadioButton("Select a standard correlation");
    JRadioButton jrbRCorrelation = new JRadioButton("Select an R correlation matrix");
    JComboBox jcbCorString;
    JComboBox jcbCorObject;
    CreateGraphGUI parent;

    public CorrelatedTest(CreateGraphGUI parent) {
        super(parent, "Correlated test statistics?", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        String[] matrices = RControl.getR().eval("gMCP:::getAllQuadraticMatrices()").asRChar().getData();
        String[] correlations = new String[]{"Dunnett"};
        this.jcbCorString = new JComboBox<String>(correlations);
        this.jcbCorObject = new JComboBox<String>(matrices);
        if (matrices.length == 1 && matrices[0].equals("No quadratic matrices found.")) {
            this.jcbCorObject.setEnabled(false);
            this.jrbRCorrelation.setEnabled(false);
        }
        this.jrbNoCorrelation.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrbNoCorrelation);
        group.add(this.jrbStandardCorrelation);
        group.add(this.jrbRCorrelation);
        this.jrbNoCorrelation.addActionListener(this);
        this.jrbStandardCorrelation.addActionListener(this);
        this.jrbRCorrelation.addActionListener(this);
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)this.jrbNoCorrelation, cc.xy(2, row));
        this.getContentPane().add((Component)this.jrbStandardCorrelation, cc.xy(2, row += 2));
        this.getContentPane().add((Component)this.jcbCorString, cc.xy(4, row));
        this.getContentPane().add((Component)this.jrbRCorrelation, cc.xy(2, row += 2));
        this.getContentPane().add((Component)this.jcbCorObject, cc.xy(4, row));
        this.getContentPane().add((Component)this.ok, cc.xy(4, row += 2));
        this.ok.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.jrbNoCorrelation && e.getSource() == this.ok) {
            String correlation = "";
            if (this.jrbStandardCorrelation.isSelected()) {
                correlation = ", correlation=\"" + this.jcbCorString.getSelectedItem() + "\"";
            } else if (this.jrbRCorrelation.isSelected()) {
                correlation = ", correlation=" + this.jcbCorObject.getSelectedItem() + "";
            }
            boolean[] rejected = RControl.getR().eval("gMCP(" + this.parent.getGraphView().getNL().initialGraph + "," + this.parent.getGraphView().getPView().getPValuesString() + correlation + ", alpha=" + this.parent.getPView().getTotalAlpha() + ")@rejected").asRLogical().getData();
            new RejectedDialog(this.parent, rejected, this.parent.getGraphView().getNL().getKnoten());
            this.dispose();
        }
    }
}

