/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.CreateGraphGUI;
import org.mutoss.gui.datatable.DataTable;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.NetzListe;
import org.mutoss.gui.graph.PView;

public class ControlMGraph {
    private static final Log logger = LogFactory.getLog(ControlMGraph.class);
    String name;
    CreateGraphGUI parent;

    public ControlMGraph(String name, CreateGraphGUI parent) {
        this.name = name;
        this.parent = parent;
    }

    public NetzListe getNL() {
        return this.getGraphView().getNL();
    }

    public String getName() {
        return this.name;
    }

    public JFrame getMainFrame() {
        return this.parent;
    }

    public PView getPView() {
        return this.parent.getPView();
    }

    public GraphView getGraphView() {
        return this.parent.getGraphView();
    }

    public void updateEdge(int from, int to, Double w) {
        logger.info((Object)("Adding Edge from " + from + " to " + to + " with weight " + w + "."));
        Edge e = this.getNL().findEdge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to));
        if (e != null) {
            int x = e.getK1();
            int y = e.getK2();
            if (w != 0.0) {
                this.getNL().addEdge(new Edge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to), w, this.getNL().vs, x, y));
            } else {
                this.getNL().removeEdge(e);
            }
        } else {
            this.getNL().addEdge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to), w);
        }
        this.getNL().repaint();
    }

    public DataTable getDataTable() {
        return this.parent.getDataTable();
    }
}

