/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.Vector;
import org.mutoss.config.Configuration;
import org.mutoss.gui.graph.NodeListener;
import org.mutoss.gui.graph.VS;

public class Node {
    public Vector<NodeListener> listener = new Vector();
    public long nr;
    int x;
    int y;
    public String name;
    boolean fix = false;
    boolean drag = false;
    VS vs;
    public double alpha;
    private Color color = Color.WHITE;
    boolean rejected = false;
    public static int r = 25;
    static int count = 1;
    DecimalFormat format = new DecimalFormat("#.###");

    public static void setRadius(int radius) {
        r = radius;
    }

    public Node(int nr, String name, int x, int y, VS vs) {
        this.nr = nr;
        this.name = name;
        this.setX(x);
        this.setY(y);
        this.vs = vs;
        ++count;
    }

    public Node(String name, int x, int y, double alpha, VS vs) {
        this.nr = count;
        ++count;
        this.name = name;
        this.setX(x);
        this.setY(y);
        this.vs = vs;
        this.alpha = alpha;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.x = x = (x + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.y = y = (y + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public void paintYou(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getColor());
        Ellipse2D.Double e = new Ellipse2D.Double();
        ((RectangularShape)e).setFrame((double)this.x * this.vs.getZoom(), (double)this.y * this.vs.getZoom(), (double)(r * 2) * this.vs.getZoom(), (double)(r * 2) * this.vs.getZoom());
        g2d.fill(e);
        g2d.setColor(new Color(0, 0, 0));
        ((RectangularShape)e).setFrame((double)this.x * this.vs.getZoom(), (double)this.y * this.vs.getZoom(), (double)(r * 2) * this.vs.getZoom(), (double)(r * 2) * this.vs.getZoom());
        g2d.draw(e);
        if (this.vs.moreInfo) {
            Line2D.Double l = new Line2D.Double();
            ((Line2D)l).setLine((double)this.x * this.vs.getZoom(), (double)(this.y + r) * this.vs.getZoom(), (double)(this.x + r * 2) * this.vs.getZoom(), (double)(this.y + r) * this.vs.getZoom());
            g2d.draw(l);
            ((Line2D)l).setLine((double)(this.x + r) * this.vs.getZoom(), (double)(this.y + r) * this.vs.getZoom(), (double)(this.x + r) * this.vs.getZoom(), (double)(this.y + r * 2) * this.vs.getZoom());
            g2d.draw(l);
            g2d.setFont(new Font("Arial", 0, (int)(8.0 * this.vs.getZoom())));
            FontRenderContext frc = g2d.getFontRenderContext();
            if (this.vs.shownr) {
                Rectangle2D rc = g2d.getFont().getStringBounds("" + this.nr, frc);
                g2d.drawString("" + this.nr, (float)((double)(this.x + r) * this.vs.getZoom() - rc.getWidth() / 2.0), (float)((double)(this.y + r) * this.vs.getZoom() - rc.getHeight() / 2.0));
            } else {
                Rectangle2D rc = g2d.getFont().getStringBounds(this.name, frc);
                g2d.drawString("" + this.name, (float)((double)(this.x + r) * this.vs.getZoom() - rc.getWidth() / 2.0), (float)((double)(this.y + r) * this.vs.getZoom() - rc.getHeight() / 2.0));
            }
        } else {
            Rectangle2D rc;
            g2d.setFont(new Font("Arial", 0, (int)(12.0 * this.vs.getZoom())));
            FontRenderContext frc = g2d.getFontRenderContext();
            if (this.vs.shownr) {
                rc = g2d.getFont().getStringBounds("" + this.nr, frc);
                g2d.drawString("" + this.nr, (float)((double)(this.x + r) * this.vs.getZoom() - rc.getWidth() / 2.0), (float)(((double)(this.y + r) - 0.25 * (double)r) * this.vs.getZoom()));
            } else {
                rc = g2d.getFont().getStringBounds(this.name, frc);
                g2d.drawString(this.name, (float)((double)(this.x + r) * this.vs.getZoom() - rc.getWidth() / 2.0), (float)(((double)(this.y + r) - 0.25 * (double)r) * this.vs.getZoom()));
            }
            rc = g2d.getFont().getStringBounds(this.getWS(), frc);
            g2d.drawString(this.getWS(), (float)((double)(this.x + r) * this.vs.getZoom() - rc.getWidth() / 2.0), (float)(((double)this.y + 1.5 * (double)r) * this.vs.getZoom()));
        }
    }

    private String getWS() {
        return this.format.format(this.alpha);
    }

    public static int getRadius() {
        return r;
    }

    public boolean inYou(int x, int y) {
        return ((double)x / this.vs.getZoom() - (double)this.x - (double)r) * ((double)x / this.vs.getZoom() - (double)this.x - (double)r) + ((double)y / this.vs.getZoom() - (double)this.y - (double)r) * ((double)y / this.vs.getZoom() - (double)this.y - (double)r) <= (double)(r * r);
    }

    public void mouseRelease(MouseEvent e) {
    }

    public void setAlpha(double w, NodeListener me) {
        this.alpha = w;
        for (NodeListener l : this.listener) {
            if (me == l) continue;
            l.updated(this);
        }
        this.vs.nl.repaint();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setColor(Color color) {
        this.color = color;
        this.vs.repaint();
    }

    public Color getColor() {
        if (this.rejected) {
            return Color.MAGENTA;
        }
        return this.color;
    }

    public void addNodeListener(NodeListener l) {
        this.listener.add(l);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void reject() {
        this.color = Color.MAGENTA;
        this.rejected = true;
    }
}

