% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{background}
\alias{background}
\title{Configure Background Plugin for G6}
\usage{
background(
  key = NULL,
  width = "100\%",
  height = "100\%",
  backgroundColor = NULL,
  backgroundImage = NULL,
  backgroundSize = "cover",
  backgroundPosition = NULL,
  backgroundRepeat = NULL,
  opacity = NULL,
  transition = "background 0.5s",
  zIndex = "-1",
  ...
)
}
\arguments{
\item{key}{Unique identifier for updates (string, default: NULL).}

\item{width}{Background width (string, default: "100\%").}

\item{height}{Background height (string, default: "100\%").}

\item{backgroundColor}{Background color (string, default: NULL).}

\item{backgroundImage}{Background image URL (string, default: NULL).}

\item{backgroundSize}{Background size (string, default: "cover").}

\item{backgroundPosition}{Background position (string, default: NULL).}

\item{backgroundRepeat}{Background repeat (string, default: NULL).}

\item{opacity}{Background opacity (string, default: NULL).}

\item{transition}{Transition animation (string, default: "background 0.5s").}

\item{zIndex}{Stacking order (string, default: "-1").}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/background}.}
}
\value{
A list with the configuration settings for the background plugin.
}
\description{
Creates a configuration object for the background plugin in G6.
This plugin adds a customizable background to the graph canvas.
}
\examples{
# Basic background color
bg <- background(backgroundColor = "#f0f0f0")

# Background with image
bg <- background(
  backgroundImage = "https://example.com/background.jpg",
  backgroundSize = "contain",
  backgroundRepeat = "no-repeat",
  backgroundPosition = "center"
)

# Semi-transparent background with transition
bg <- background(
  backgroundColor = "#000000",
  opacity = "0.3",
  transition = "all 1s ease-in-out"
)
}
