% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.fuzzylm.R
\name{summary.fuzzylm}
\alias{summary.fuzzylm}
\title{Summarizes Fuzzy Linear Regression}
\usage{
\method{summary}{fuzzylm}(object, ...)
}
\arguments{
\item{object}{a \code{fuzzylm} object.}

\item{...}{additional parameters passed to and from other methods.}
}
\value{
Returns a list with models for the central tendency and spreads from the fuzzy
  linear regression.
}
\description{
Calculates the summary from the \code{fuzzylm} object.
}
\examples{
x <- rep(1:3, each = 5)
y <- c(rnorm(5, 1), rnorm(5, 2), rnorm(5, 3))
dat <- data.frame(x = x, y = y)
f <- fuzzylm(y ~ x, dat)
sum.f <- summary(f)
sum.f
}
\keyword{fuzzy}
