% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/backend_api-13.MultisessionFutureBackend-class.R
\name{multisession}
\alias{multisession}
\title{Create a multisession future whose value will be resolved asynchronously in a parallel \R session}
\usage{
multisession(
  ...,
  workers = availableCores(),
  lazy = FALSE,
  rscript_libs = .libPaths(),
  gc = FALSE,
  earlySignal = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{workers}{The number of parallel processes to use.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{rscript_libs}{A character vector of \R package library folders that
the workers should use.  The default is \code{.libPaths()} so that multisession
workers inherits the same library path as the main \R session.
To avoid this, use \code{plan(multisession, ..., rscript_libs = NULL)}.
\emph{Important: Note that the library path is set on the workers when they are
created, i.e. when \code{plan(multisession)} is called.  Any changes to
\code{.libPaths()} in the main R session after the workers have been created
will have no effect.}
This is passed down as-is to \code{\link[parallelly:makeClusterPSOCK]{parallelly::makeClusterPSOCK()}}.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{\ldots}{Additional arguments passed to \code{\link[=Future]{Future()}}.}
}
\value{
A MultisessionFuture.
If \code{workers == 1}, then all processing is done in the
current/main \R session and we therefore fall back to using a
lazy future.  To override this fallback, use \code{workers = I(1)}.
}
\description{
A multisession future is a future that uses multisession evaluation,
which means that its \emph{value is computed and resolved in
parallel in another \R session}.
}
\details{
This function is \emph{not} meant to be called directly.  Instead, the
typical usages are:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures in parallel on the local machine via as many background
# processes as available to the current R process
plan(multisession)

# Evaluate futures in parallel on the local machine via two background
# processes
plan(multisession, workers = 2)
}\if{html}{\out{</div>}}

The background \R sessions (the "workers") are created using
\code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}}.

For the total number of
\R sessions available including the current/main \R process, see
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}.

A multisession future is a special type of cluster future.
}
\examples{
\donttest{

## Use multisession futures
plan(multisession)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multisession future is evaluated in a separate R session.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## Explicitly close multisession workers by switching plan
plan(sequential)
}
}
\seealso{
For processing in multiple forked \R sessions, see
\link{multicore} futures.

Use \code{\link[parallelly:availableCores]{parallelly::availableCores()}} to see the total number of
cores that are available for the current \R session.
}
