% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolved.R
\name{resolved}
\alias{resolved}
\title{Check whether a future is resolved or not}
\usage{
resolved(x, ...)
}
\arguments{
\item{x}{A \link{Future}, a list, or an environment (which also
includes \link[listenv:listenv]{list environment}.}

\item{\dots}{Not used.}
}
\value{
A logical of the same length and dimensions as \code{x}.
Each element is TRUE unless the corresponding element is a
non-resolved future in case it is FALSE.
}
\description{
Check whether a future is resolved or not
}
\details{
This method needs to be implemented by the class that implement
the Future API.  The implementation must never throw an error,
but only return either TRUE or FALSE.
It should also be possible to use the method for polling the
future until it is resolved (without having to wait infinitely long),
e.g. \code{while (!resolved(future)) Sys.sleep(5)}.
}
