% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionPalette.R
\name{fusionPalette}
\alias{fusionPalette}
\title{Adding FusionCharts palette}
\usage{
fusionPalette(
  fusionPlot,
  palettecolors = NULL,
  usePlotGradientColor = FALSE,
  plotGradientColor = "#003366",
  plotFillAngle = "0",
  plotFillRatioStart = "90",
  plotFillRatioEnd = "100",
  plotFillAlpha = "100",
  showPlotBorder = FALSE,
  drawFullAreaBorder = FALSE,
  inheritPlotBorderColor = FALSE,
  plotBorderDashed = FALSE,
  plotBorderDashLen = "4",
  plotBorderDashGap = "4",
  plotBorderThickness = "1",
  plotBorderColor = "#666666",
  useRoundEdges = FALSE,
  plotHoverEffect = FALSE,
  plotFillHoverColor = "#5D62B5",
  plotFillHoverAlpha = "100",
  plotBorderHoverColor = "#000000",
  plotBorderHoverAlpha = "100",
  plotBorderHoverThickness = "1",
  plotBorderHoverDashed = TRUE,
  plotBorderHoverDashLen = "6",
  plotBorderHoverDashGap = "2"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{palettecolors}{Specify your custom palette for data plots}

\item{usePlotGradientColor}{Use the gradient effect}

\item{plotGradientColor}{Specify the hex code of the gradient color}

\item{plotFillAngle}{Set the fill angle for the gradient (0 to 360)}

\item{plotFillRatioStart}{Specify the start of the gradient effect}

\item{plotFillRatioEnd}{Specify the end of the gradient effect}

\item{plotFillAlpha}{Set the transparency of the gradient fill}

\item{showPlotBorder}{Show the plot border}

\item{drawFullAreaBorder}{To set the top border of the area chart (only works if showPlotBorder = TRUE)}

\item{inheritPlotBorderColor}{Enable the plot border to inherit the color of an area plot}

\item{plotBorderDashed}{Make the border dashed}

\item{plotBorderDashLen}{Set the length of each dash in plot-border (in pixels)}

\item{plotBorderDashGap}{Set the gap between two consecutive dashes in plot border (in pixels)}

\item{plotBorderThickness}{Set the thickness of the plot border}

\item{plotBorderColor}{Set the color of the plot border}

\item{useRoundEdges}{Enable rounded edges (2D Column or Bar charts only)}

\item{plotHoverEffect}{Enable hover effects for the data plots}

\item{plotFillHoverColor}{Set the hover color for data plots in hex code format}

\item{plotFillHoverAlpha}{Set the transparency for hover color for data plots}

\item{plotBorderHoverColor}{Set the hover border color}

\item{plotBorderHoverAlpha}{Set the transparency of hover border for data plots}

\item{plotBorderHoverThickness}{Set the hover border thickness (in pixels)}

\item{plotBorderHoverDashed}{Make dashed borders on hover}

\item{plotBorderHoverDashLen}{Set the length of each dash for all data plots on hover}

\item{plotBorderHoverDashGap}{Set the gap between two consecutive dashes for all data plots on hover(in pixels)}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/data-plot}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))

df \%>\%
fusionPlot(x = "label", y = "value", type = "pie2d") \%>\%
fusionPalette(palettecolors = c("5d62b5", "29c3be", "f2726f")) \%>\%
fusionTheme(theme = "gammel")

}
