% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-files-wd.R
\name{list_files_wd}
\alias{list_files_wd}
\title{List Files in Working Directory}
\usage{
list_files_wd(
  path = ".",
  pattern = stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE),
  rmv_index = TRUE
)
}
\arguments{
\item{path}{Character vector or path. Default is "." which will set the
starting location for \code{relative_paths}.}

\item{pattern}{Regex pattern to keep only matching files. Default is
\code{stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE)} which will
keep only R, Rmarkdown and Quarto documents. To keep all files use \code{"."}.}

\item{rmv_index}{Logical, most repos containing blogdown sites will have an
index.R file at the root. Change to \code{FALSE} if you don't want this file
removed.}
}
\value{
Dataframe with columns of \code{relative_paths} and \code{absolute_paths}.
}
\description{
Return a dataframe containing the paths of files in the working directory.
Generally used prior to \verb{spot_\{funs/pkgs\}_files()}.
}
\details{
Can also be used outside of working directory if \code{path} is specified.
}
\examples{
\donttest{
library(dplyr)
library(funspotr)

# pulling and analyzing my R file github gists
files_local <- list_files_wd()

# Will just parse the first 2 files/gists
contents <- spot_funs_files(slice(files_local, 2:3))

contents \%>\%
  unnest_results()
}
}
\seealso{
\code{\link[=list_files_github_repo]{list_files_github_repo()}}, \code{\link[=list_files_github_gists]{list_files_github_gists()}}
}
