% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-files-gh-repo.R
\name{github_spot_pkgs}
\alias{github_spot_pkgs}
\alias{github_spot_funs}
\alias{github_spot_things}
\title{Spot Packages or Functions from Github Repository}
\usage{
github_spot_pkgs(
  repo,
  branch = "main",
  ...,
  preview = FALSE,
  rmv_index = TRUE,
  custom_urls = NULL
)

github_spot_funs(
  repo,
  branch = "main",
  ...,
  preview = FALSE,
  rmv_index = TRUE,
  custom_urls = NULL
)
}
\arguments{
\item{repo}{Github repository, e.g. "brshallo/feat-eng-lags-presentation"}

\item{branch}{Branch of github repository, default is "main".}

\item{...}{Arguments passed onto \verb{spot_*()}.}

\item{preview}{Logical, if set to \code{TRUE} will return dataframe of urls that
will be passed through \code{spot_funs()} or \code{spot_pkgs()} without parsing
files. See README for example of how this can be combined with
\code{custom_urls} to only parse a subset of files identified.}

\item{rmv_index}{Logical, most repos containing blogdown sites will have an
index.R file at the root. Change to \code{FALSE} if you don't want this file
removed.}

\item{custom_urls}{Option to pass in a dataframe with columns \code{contents} and
\code{urls} to override the default urls in the repo to parse. Default is
\code{NULL}. See README for example.}
}
\value{
Dataframe with \code{relative_paths} and \code{absolute_paths} of file paths
along with a list-column \code{spotted} containing \code{purrr::safely()} lists of
"result" and "error" for each file parsed. See \code{unnest_results()}
for helper to put into an easier to read format.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These function were deprecated with updates to the API that modularized this
functionality into two steps \verb{list_files_*()} and \verb{spot_*()}.

\code{github_spot_pkgs()} : Spot all packages that show-up in R or Rmarkdown
documents in the github repository. Essentially a wrapper for mapping
\code{spot_pkgs()} across multiple files.

\code{github_spot_funs()} : Spot all functions and their corresponding packages
that show-up in R or Rmarkdown documents in the github repository.
Essentially a wrapper for mapping \code{spot_pkgs()} across multiple files.

Meant for cases where packages and scripts are in \emph{the same} file. In cases
where this is not the case will need to build an alternative workflow. See
unexported functions in R/github-spot.R for some potentially helpful building
blocks.
}
\seealso{
spot_pkgs spot_funs spot_funs_custom unnest_results
}
\keyword{internal}
