% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_fric.R
\name{fd_fric}
\alias{fd_fric}
\title{Compute Functional Richness (FRic)}
\usage{
fd_fric(traits, sp_com, stand = FALSE)
}
\arguments{
\item{traits}{Trait matrix with species as rows and traits as columns.
It has to contain exclusively numerical values. This can be
either a \code{matrix}, a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}}
object.}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}

\item{stand}{a boolean indicating whether to standardize FRic values over
the observed maximum over all species (default: \code{FALSE}).
This scales FRic between 0 and 1.
\strong{NB}: The maximum FRic values only considers species that are
present in \strong{both} site-species and trait matrices.
If you want to consider species that are absent
in the site-species matrix, add corresponding columns of 0s.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} the names of the sites as the row names of the input \code{sp_com},
\item \code{FRic} the values of functional richness at each site.
}

NB: FRic is equal to \code{NA} when there are strictly less species in a site
than the number of provided traits.
}
\description{
Functional Richness is computed as the volume of the convex hull from all
included traits.
}
\details{
By default, when loading \pkg{fundiversity}, the functions to
compute convex hulls are
\href{https://en.wikipedia.org/wiki/Memoization}{memoised} through the \code{memoise}
package if it is installed. To deactivate this behavior you can set the
option \code{fundiversity.memoise} to \code{FALSE} by running the following line:
\code{options(fundiversity.memoise = FALSE)}. If you use it interactively it will
only affect your current session. Add it to your script(s) or \code{.Rprofile}
file to avoid toggling it each time.
}
\section{Parallelization}{

The computation of this function can be parallelized thanks to
\code{\link[future:plan]{future::plan()}}. To get more information on how to parallelize your
computation please refer to the parallelization vignette with:
\code{vignette("parallel", package = "fundiversity")}
}

\examples{
data(traits_birds)
fd_fric(traits_birds)

}
\references{
Cornwell W. K., Schwilk D. W., Ackerly D. D. (2006), A trait-based test for
habitat filtering; convex hull volume, Ecology 84(6),
\doi{10.1890/0012-9658(2006)87[1465:ATTFHF]2.0.CO;2}
}
