% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_jack.R
\name{validate_using_cross_validation}
\alias{validate_using_cross_validation}
\title{Predicting by cross-validation of assembly performances}
\usage{
validate_using_cross_validation(fobs, assMotif, mOccur, xpr,
                  opt.mean = "amean", opt.model = "bymot",
                  opt.jack = FALSE, jack = c(3,4)  )
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{} is generated
by the function \code{stats::setNames}.}

\item{opt.mean}{switchs to arithmetic formula \code{opt.mean = "amean"}
or geometric formula \code{opt.mean = "gmean"}.}

\item{opt.model}{switchs to model type:
simple mean by assembly motif \code{opt.model = "bymot"}
or linear model with assembly motif \code{opt.model = "byelt"}.}

\item{opt.jack}{a logical,
that switchs towards cross-validation method.

If \code{opt.jack = FALSE}, a "leave-one-out" is used:
predicted performances are computed
as the mean of performances of assemblages
that share a same assembly motif,
experiment by experiment,
except the only assemblage to predict. \cr

If \code{opt.jack = TRUE}, a jackknife method is used:
the set of assemblages belonging to a same assembly motif is divided
into \code{jack[2]} subsets of \code{jack[1]} assemblages.
Predicted performances are computed,
experiment by experiment,
by excluding \code{jack[1]} assemblages,
including the assemblage to predict.
If the total number of assemblages belonging
to the assembly motif is lower than \code{jack[1]*jack[2]},
predictions are computed by Leave-One-Out method.}

\item{jack}{an integer vector of length \code{2}.
The vector specifies the parameters for jackknife method.
The first integer \code{jack[1]} specifies the size of subset,
the second integer \code{jack[2]} specifies the number of subsets.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are predicted
according to \code{opt.mean} and \code{opt.model}.
}
\description{
Take a vector \code{fobs} of assembly performances
over several experiments
and return a vector of performances
predicted as the mean performances of assemblages
that share the same assembly motif.\cr
Assembly motifs are labelled in the vector \code{assMotif}.
Experiments are labelled in the vector \code{xpr}.
Modelling options are indicated in \code{opt.mean} and \code{opt.model}.
Occurrence matrix \code{mOccur} is used if \code{opt.model =  "byelt"}.
Cross-validation is leave-one-out or jackknifesi
}
\details{
None.
}
\seealso{
\code{\link{calibrate_byminrss}} \cr
\code{\link{predict_performance}}
}
\keyword{internal}
