% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating.R
\name{validate_ftree}
\alias{validate_ftree}
\title{Predictions of assembly performances
       using a species clustering tree}
\usage{
validate_ftree(tree.I, fobs, mOccur,
              xpr = stats::setNames(rep(1, length(fobs)),
                                    rep("a", length(fobs))),
              opt.method = "divisive", opt.mean = "amean",
              opt.model = "byelt",
              opt.jack   = FALSE,
              jack       = as.integer(c(3, 4)),
              opt.nbMax  = dim(mOccur)[2])
}
\arguments{
\item{tree.I}{an integer square-matrix.
The matrix represents a hierarchical tree of species clustering.}

\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{opt.method}{a string that specifies the method to use.
\code{opt.method = c("sort", "divisive", "agglomerative", "cluster")}.
The three first methods generate hierarchical trees.
Each tree is complete, running from a unique trunk
to as many leaves as components.
The last method generates, at each level of the tree,
a clustering of components into a given, predefined number of clusters.
Because it is repeated from the trunk until to leaves,
by increasing the number of clusters,
the method generates a non-hierarchical tree. \cr

If \code{opt.method = "sort"}, the components are sorted
by their effect of assemblage performances. \cr

If \code{opt.method = "divisive"}, the components are clustered
according to a hierarchical process
by using a divisive method,
from the trivial cluster where all components are together,
towards the clustering where each component is a cluster. \cr

If \code{opt.method = "agglomerative"}, the components are clustered
according to a hierarchical process
by using an agglomerative method,
from the trivial clustering where each component is a clsuter,
towards the cluster where all components are together.
The method that gives the best result is \code{opt.method = "divisive"}. \cr

If \code{opt.method = "cluster"}, the components are clustered
according to a non-hierarchical process
by using the method of McNaughton-Smith et al., 1964.
In this case, one must specify the number of wished clusters.

Recall that, if \code{affectElt} is specified,
the option \code{opt.method} does not need to be filled out.
\code{affectElt} determines a level of component clustering,
and a tree is built:
\emph{(i)} by using \code{opt.method =  "divisive"}
from the defined level in tree towards as many leaves as components;
\emph{(ii)} by using \code{opt.method =  "agglomerative"}
from the defined level in tree towards the trunk of tree.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}

\item{opt.model}{a character equals to \code{"bymot"} or \code{"byelt"}.
Switch to simple mean by assembly motif if \code{opt.model = "bymot"}.
Switch to linear model with assembly motif if \code{opt.model = "byelt"}.}

\item{opt.jack}{a logical,
that switchs towards cross-validation method.

If \code{opt.jack = FALSE}, a "leave-one-out" is used:
predicted performances are computed
as the mean of performances of assemblages
that share a same assembly motif,
experiment by experiment,
except the only assemblage to predict. \cr

If \code{opt.jack = TRUE}, a jackknife method is used:
the set of assemblages belonging to a same assembly motif is divided
into \code{jack[2]} subsets of \code{jack[1]} assemblages.
Predicted performances are computed,
experiment by experiment,
by excluding \code{jack[1]} assemblages,
including the assemblage to predict.
If the total number of assemblages belonging
to the assembly motif is lower than \code{jack[1]*jack[2]},
predictions are computed by Leave-One-Out method.}

\item{jack}{an integer vector of length \code{2}.
The vector specifies the parameters for jackknife method.
The first integer \code{jack[1]} specifies the size of subset,
the second integer \code{jack[2]} specifies the number of subsets.}

\item{opt.nbMax}{an integer, that indicates the maximum number
of tree levels to cluster.
By default, \code{opt.nbMax = nbElt} for clustering components
all along the tree, from the trunc to the leaves, to be able to determine
the optimum number of component functional groups.
However, in \code{ftest_*} and \code{fboot_*} functions,
there is no point in cluster the components
beyond the optimum number of functional groups. In these functions,
\code{opt.nbMax = } optimum number of functional groups, by default.}
}
\value{
Return a list containing predictions of assembly performances
      and statistics computed by using a species clustering tree.

 Recall of inputs:
 \itemize{
 \item \code{nbElt, nbAss}{: the numbers of components, of assemblages}
 \item \code{opt.method}{: the method used to cluster components,}
 \item \code{opt.mean}{: the option for mean values computing,}
 \item \code{opt.model}{: the option for prediction modelling,}
 \item \code{opt.jack}{: the option for method of cross-validation,}
 \item \code{jack}{: the parameters for jackknife,}
 \item \code{fobs}{: the vector of observed performances of assemblages,}
 \item \code{mOccur}{: the matrix of component occurrence,}
 \item \code{xpr}{: the vector of labels of different experiments.}
 }

 Primary and secondary trees of element clustering:
 \itemize{
 \item \code{tree.I}{: the primary tree of component clustering,}
 \item \code{tree.II}{: the validated secondary
  tree of component clustering,}
 \item \code{nbOpt}{: the optimum number of clusters,}
 }

 Matrices of calibration and prediction using tree.I
   and associated statistics:
 \itemize{
 \item \code{mCal}{: the matrix of modelled values,}
 \item \code{mPrd}{: the matrix of values predicted by cross-validation,}
 \item \code{mMotifs}{: the matrix of labels of assembly motifs,}
 \item \code{mStats}{: the matrix of associated statistics.}
 }

 Matrices of calibaration and prediction using tree.II
   and associated statistics:
 \itemize{
 \item \code{tCal}{: the matrix of values modelled
   using the valid part of tree,}
 \item \code{tPrd}{: the matrix of values predicted
   using the valid part of tree,}
 \item \code{tStats}{: statistics of valid tree model goodness-of-fit,}
 \item \code{tNbcl}{: the number of clusters used
   or computing each performance.}
 }
}
\description{
Take a hierarchical tree of species clustering,
  a matrix of occurrency and the corresponding vector of performances,
  and return the predictions, statistics and other informations.
}
\details{
None.
}
\keyword{internal}
