% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_loo.R
\name{validate_amean_byelt_LOO}
\alias{validate_amean_byelt_LOO}
\title{Predicting the performances
 by elements occurring within assembly motif
 using leave-one-out method}
\usage{
validate_amean_byelt_LOO(fobs, assMotif, mOccur)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the average
of mean performances of assemblages
that share the same assembly motif
and that contain the same elements
as the assemblage to predict \code{opt.model = "byelt"} .
}
\description{
Take a vector \code{fobs}
of performances of assemblages
that share a same assembly motif,
and return a vector of performances
predicted as the arithmetic mean
of performances of assemblages
that contain the same elements as the assemblage to predict.\cr

All assemblages share the same assembly motif.
}
\details{
Modelled performances are computed
using arithmetic mean \code{opt.mean = "amean"} of performances.
Assemblages share a same assembly motif \code{opt.model = "bymot"}.
Modelled performances are the average
of mean performances of assemblages that contain the same elements
as the assemblage to predict,
except the assemblage to predict.
This procedure corresponds to a linear model with each assembly motif
based on the element occurrence in each assemblage.
}
\seealso{
\code{\link{amean_bymot_LOO}} arithmetic mean
  by assembly motif \cr
\code{\link{gmean_bymot_LOO}} geometric mean
  by assembly motif \cr
\code{\link{gmean_byelt_LOO}} geometric mean
  by elements occurring within assembly motif \cr
}
\keyword{internal}
