% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclust.R
\name{read_fstats}
\alias{read_fstats}
\title{Read the file containing the statistics of a functional clustering}
\usage{
read_fstats(filename = "", nbElt)
}
\arguments{
\item{filename}{a string, used as radical for the 6 file names.}

\item{nbElt}{an integer, that indicates the number of components.}
}
\value{
The statistics
  resulting from a functional clustering
  and recorded in the files \code{"filename.stats.csv"}.
}
\description{
Read the file \code{"filename.stats.csv"}
  containing the statistics of a functional clustering
  and saved by using the function \code{fclust_write()}.
}
\details{
The results are saved in
  the file \code{"filename.stats.csv"}.
  If the file does not exist or is corrupted, the function is stopped.
}
\seealso{
\code{\link{read_foptions}}{:
    read the file \code{"filename.options.csv"}
    generated by \code{\link{fclust_write}}.} \cr
  \code{\link{read_finputs}}{:
    read the file \code{"filename.inputs.csv"}
    generated by \code{\link{fclust_write}}.} \cr
  \code{\link{read_ftrees}}{:
    read the file \code{"filename.trees.csv"}
    generated by \code{\link{fclust_write}}.} \cr
  \code{\link{read_fmatrices}}{:
    read the file \code{"filename.matrices.csv"}
    generated by \code{\link{fclust_write}}.} \cr
  \code{\link{read_fstats}}{:
    read the file \code{"filename.stats.csv"}
    generated by \code{\link{fclust_write}}.} \cr
}
\keyword{internal}
